/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.ide.highlighter.JavaInJspHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.jsp.JspDirectiveHighlighter;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lexer.JspHighlightingLexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.el.ELHighlighter;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;

public class JspEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private Language myTemplateLanguage;

    public JspEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile virtualFile) {
        super(SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JSP, (Project)project, (VirtualFile)virtualFile), scheme);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        JavaInJspHighlighter javaHighlighter = JspWithOtherWorldIntegrationService.getInstance().createJavaHighlighter(project, virtualFile);
        LayerDescriptor javaLayer = new LayerDescriptor((SyntaxHighlighter)javaHighlighter, "\n", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
        this.registerLayer((IElementType)BaseJspElementType.JSP_DECLARATION, javaLayer);
        this.registerLayer((IElementType)BaseJspElementType.JSP_SCRIPTLET, javaLayer);
        this.registerLayer((IElementType)BaseJspElementType.JSP_EXPRESSION, javaLayer);
        SyntaxHighlighter elHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)Language.findInstance(ELLanguage.class), (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor elLayer = new LayerDescriptor(elHighlighter, "\n", ELHighlighter.EL_BACKGROUND);
        this.registerLayer((IElementType)ELElementType.JSP_EL_HOLDER, elLayer);
        JspDirectiveHighlighter directiveHighlighter = new JspDirectiveHighlighter();
        LayerDescriptor directiveLayer = new LayerDescriptor((SyntaxHighlighter)directiveHighlighter, "\n", JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_BACKGROUND);
        this.registerLayer((IElementType)BaseJspElementType.JSP_DIRECTIVE, directiveLayer);
    }

    protected boolean updateLayers() {
        Language templateLanguage = this.getCurrentTemplateLanguage();
        if (!Comparing.equal((Object)this.myTemplateLanguage, (Object)templateLanguage)) {
            this.unregisterLayer(JspTokenType.JSP_TEMPLATE_DATA);
            this.myTemplateLanguage = templateLanguage;
            SyntaxHighlighter templateLanguageHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myTemplateLanguage, (Project)this.myProject, (VirtualFile)this.myVirtualFile);
            this.registerLayer(JspTokenType.JSP_TEMPLATE_DATA, new LayerDescriptor(templateLanguageHighlighter, "", null));
            return true;
        }
        return false;
    }

    private Language getCurrentTemplateLanguage() {
        PsiDocumentManager instance;
        PsiFile psiFile;
        PsiFile templateLanguageFile;
        Language templateLanguage = null;
        Document document = this.getDocument();
        if (this.myProject != null && document != null && !this.myProject.isDisposed() && (templateLanguageFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)(psiFile = (instance = PsiDocumentManager.getInstance((Project)this.myProject)).getPsiFile(document)))) != null && psiFile instanceof BaseJspFile) {
            BaseJspFile file = (BaseJspFile)psiFile;
            ((JspHighlightingLexer)this.getLexer()).setFile(file);
            templateLanguage = file.getViewProvider().getTemplateDataLanguage();
        }
        if (templateLanguage == null || templateLanguage == NewJspLanguage.INSTANCE) {
            templateLanguage = Language.findInstance(HTMLLanguage.class);
        }
        return templateLanguage;
    }
}

