/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl.contextchooser;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.javaee.web.WebContextManager;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.ui.WebPathChooserDescriptor;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspContextChooserPanel
extends HectorComponentPanel {
    private static final TreeFileChooser.PsiFileFilter JSP_FILE_FILTER = new TreeFileChooser.PsiFileFilter(){

        public boolean accept(PsiFile file) {
            return JspContextChooserPanel.isJspFile(file);
        }
    };
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton myContextFile;
    private ComboboxWithBrowseButton myContextFolder;
    private JLabel myContextFileLabel;
    private JLabel myContextFolderLabel;
    private final PsiFile myFile;
    @Nullable
    private BaseJspFile mySelectedContextFile;
    @Nullable
    private WebDirectoryElement mySelectedFolder;
    private final JspContextManager myJspContextManager;
    private boolean myDialogIsShown;
    private final Project myProject;
    private final WebContextManager myWebContextManager;

    public JspContextChooserPanel(@NotNull PsiFile file, @NotNull BaseJspFile[] contextFiles, JspContextManager jspContextManager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsp/impl/contextchooser/JspContextChooserPanel", "<init>"));
        }
        if (contextFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFiles", "com/intellij/jsp/impl/contextchooser/JspContextChooserPanel", "<init>"));
        }
        this.myDialogIsShown = false;
        this.myJspContextManager = jspContextManager;
        this.myFile = file;
        this.$$$setupUI$$$();
        this.myProject = this.myFile.getProject();
        this.myWebContextManager = WebContextManager.getInstance((Project)this.myProject);
        this.configureIncludingFiles(contextFiles);
        this.configureContextFolder(contextFiles);
    }

    private void configureContextFolder(BaseJspFile[] contextFiles) {
        WebDirectoryElement element;
        WebDirectoryElement root;
        WebDirectoryElement contextDir;
        WebDirectoryElement parentWebDirectory = WebUtil.getWebUtil().getParentWebDirectory(this.myFile);
        if (parentWebDirectory == null) {
            this.myContextFolder.setVisible(false);
            this.myContextFolderLabel.setVisible(false);
            return;
        }
        this.mySelectedFolder = parentWebDirectory;
        LinkedHashSet<WebDirectoryElement> list = new LinkedHashSet<WebDirectoryElement>();
        if (this.mySelectedContextFile != null && (contextDir = WebUtil.getWebUtil().getParentWebDirectory((PsiFile)this.mySelectedContextFile)) != null) {
            list.add(contextDir);
            this.mySelectedFolder = contextDir;
        }
        for (WebDirectoryElement contextFile : contextFiles) {
            WebDirectoryElement contextDir2 = WebUtil.getWebUtil().getParentWebDirectory((PsiFile)contextFile);
            if (contextDir2 == null) continue;
            list.add(contextDir2);
        }
        list.add(parentWebDirectory);
        for (root = parentWebDirectory; root != null && !root.getPath().equals("/"); root = root.getParent()) {
        }
        if (root != null) {
            list.add(root);
        }
        JComboBox comboBox = this.myContextFolder.getComboBox();
        comboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        PsiFileSystemItem contextFolder = this.myWebContextManager.getContextFolder(this.myFile);
        if (contextFolder == null) {
            contextFolder = this.myFile.getParent();
        }
        if (contextFolder instanceof WebDirectoryElement) {
            this.setSelectedFolder((WebDirectoryElement)contextFolder);
        } else if (contextFolder != null && (element = WebUtil.findWebDirectoryByFile((PsiFileSystemItem)contextFolder)) != null) {
            this.setSelectedFolder(element);
        }
        this.myContextFolder.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryElement element;
                VirtualFile file;
                JspContextChooserPanel.this.myContextFolder.requestFocus();
                WebFacet webFacet = WebUtil.getWebFacet((PsiElement)JspContextChooserPanel.this.myFile);
                if (webFacet == null) {
                    return;
                }
                List webRoots = webFacet.getWebRoots();
                WebPathChooserDescriptor descriptor = new WebPathChooserDescriptor(false, true, false, false, false, false, webRoots);
                descriptor.setRoots(ContainerUtil.mapNotNull((Collection)webRoots, (Function)((NullableFunction)root1 -> root1.getFile())));
                try {
                    JspContextChooserPanel.this.myDialogIsShown = true;
                    VirtualFile toSelect = JspContextChooserPanel.this.mySelectedFolder == null ? null : JspContextChooserPanel.this.mySelectedFolder.getVirtualFile();
                    file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)JspContextChooserPanel.this.myMainPanel, (Project)JspContextChooserPanel.this.myProject, (VirtualFile)toSelect);
                }
                finally {
                    JspContextChooserPanel.this.myDialogIsShown = false;
                }
                if (file != null && (element = WebUtil.findWebDirectoryByFile((VirtualFile)file, (Project)JspContextChooserPanel.this.myProject)) != null) {
                    JspContextChooserPanel.this.setSelectedFolder(element);
                }
            }
        });
        this.myContextFolder.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = JspContextChooserPanel.this.myContextFolder.getComboBox().getSelectedItem();
                if (item != null) {
                    JspContextChooserPanel.this.setSelectedFolder((WebDirectoryElement)item);
                }
            }
        });
    }

    private void setSelectedFolder(@NotNull WebDirectoryElement folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/jsp/impl/contextchooser/JspContextChooserPanel", "setSelectedFolder"));
        }
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myContextFolder.getComboBox().getModel();
        if (model.getIndexOf(folder) < 0) {
            model.insertElementAt(folder, 0);
        }
        this.myContextFolder.getComboBox().setSelectedItem(folder);
        this.mySelectedFolder = folder;
    }

    private void configureIncludingFiles(BaseJspFile[] contextFiles) {
        if (!JspContextChooserPanel.isJspFile(this.myFile)) {
            this.myContextFile.setVisible(false);
            this.myContextFileLabel.setVisible(false);
            return;
        }
        JspFile contextFile = this.myJspContextManager.getConfiguredContextFile(this.myFile);
        if (contextFile == null && contextFiles.length > 0) {
            contextFile = contextFiles[0];
        }
        JComboBox comboBox = this.myContextFile.getComboBox();
        comboBox.setModel(new DefaultComboBoxModel<BaseJspFile>(contextFiles));
        if (contextFile != null) {
            if (contextFiles.length == 0) {
                comboBox.addItem(null);
            }
            this.setContextFile((BaseJspFile)contextFile);
        }
        this.myContextFile.setTextFieldPreferredWidth(30);
        this.myContextFile.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JspContextChooserPanel.this.myContextFile.requestFocus();
                TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)JspContextChooserPanel.this.myProject);
                String title = JspBundle.message("title.choose.jsp.file.text", new Object[0]);
                TreeFileChooser fileChooser = factory.createFileChooser(title, (PsiFile)JspContextChooserPanel.this.mySelectedContextFile, null, JSP_FILE_FILTER);
                try {
                    JspContextChooserPanel.this.myDialogIsShown = true;
                    fileChooser.showDialog();
                }
                finally {
                    JspContextChooserPanel.this.myDialogIsShown = false;
                }
                JspFile psiFile = (JspFile)fileChooser.getSelectedFile();
                if (psiFile != null) {
                    JspContextChooserPanel.this.setContextFile((BaseJspFile)psiFile);
                }
            }
        });
        this.myContextFile.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JspFile file = (JspFile)JspContextChooserPanel.this.myContextFile.getComboBox().getSelectedItem();
                JspContextChooserPanel.this.setContextFile((BaseJspFile)file);
            }
        });
    }

    private static boolean isJspFile(PsiFile file) {
        return file.getLanguage() == StdLanguages.JSP || file.getLanguage() == StdLanguages.JSPX;
    }

    public boolean canClose() {
        return !this.myDialogIsShown;
    }

    private void setContextFile(@Nullable BaseJspFile contextFile) {
        this.mySelectedContextFile = contextFile;
        JComboBox comboBox = this.myContextFile.getComboBox();
        DefaultComboBoxModel model = (DefaultComboBoxModel)comboBox.getModel();
        if (model.getIndexOf(contextFile) < 0) {
            model.insertElementAt(contextFile, 0);
        }
        comboBox.setSelectedItem(contextFile);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myJspContextManager.getConfiguredContextFile(this.myFile) != this.mySelectedContextFile || this.myWebContextManager.getContextFolder(this.myFile) != this.mySelectedFolder;
    }

    public void apply() throws ConfigurationException {
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jsp/impl/contextchooser/JspContextChooserPanel$6", "run"));
                }
                JspContextChooserPanel.this.myJspContextManager.setContextFile(JspContextChooserPanel.this.myFile, JspContextChooserPanel.this.mySelectedContextFile);
                if (JspContextChooserPanel.this.mySelectedFolder != null) {
                    JspContextChooserPanel.this.myWebContextManager.setContextFolder((PsiFileSystemItem)JspContextChooserPanel.this.myFile, (PsiFileSystemItem)JspContextChooserPanel.this.mySelectedFolder);
                }
            }
        }.execute();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        MyComboBox comboBox = new MyComboBox();
        this.myContextFile = new ComboboxWithBrowseButton((JComboBox)comboBox);
        comboBox.setRenderer(new MyListCellRenderer(comboBox));
        MyComboBox myComboBox = new MyComboBox();
        this.myContextFolder = new ComboboxWithBrowseButton((JComboBox)myComboBox);
        myComboBox.setRenderer(new MyListCellRenderer(myComboBox){

            @Override
            @Nullable
            protected String getPath(Object value) {
                return ((WebDirectoryElement)value).getPath();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 2, 0, 2), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JspBundle").getString("context.chooser.panel.title"), (int)0, (int)0, null, null));
        this.myContextFileLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JspBundle").getString("label.choose.jsp.context.text"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myContextFile;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myContextFolderLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/JspBundle").getString("context.chooser.context.folder"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myContextFolder;
        jPanel.add((Component)comboboxWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyComboBox
    extends JComboBox {
        private boolean layingOut = false;

        private MyComboBox() {
        }

        @Override
        public void doLayout() {
            try {
                this.layingOut = true;
                super.doLayout();
            }
            finally {
                this.layingOut = false;
            }
        }

        @Override
        public Dimension getSize() {
            Dimension size = super.getSize();
            if (!this.layingOut) {
                size.width = Math.max(((MyListCellRenderer)this.getRenderer()).myMaxWidth + 10, size.width);
            }
            return size;
        }
    }

    private class MyListCellRenderer
    extends DefaultListCellRenderer {
        private final JComboBox myComboBox;
        private int myMaxWidth;

        public MyListCellRenderer(JComboBox comboBox) {
            this.myComboBox = comboBox;
            this.myMaxWidth = comboBox.getPreferredSize().width;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String path = this.getPath(value);
                if (path != null) {
                    int max = index == -1 ? this.myComboBox.getWidth() - JspContextChooserPanel.this.myContextFile.getButton().getWidth() : this.myComboBox.getWidth() * 3;
                    path = this.trimPath(path, this.myComboBox, "/", max);
                    this.setText(path);
                }
            } else {
                this.setText(JspBundle.message("item.text.none.context", new Object[0]));
            }
            return rendererComponent;
        }

        @Nullable
        protected String getPath(Object value) {
            PsiFile psiFile = (PsiFile)value;
            String path = WebUtil.getWebUtil().getWebPath(psiFile);
            if (path == null) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
                VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
                if (file != null) {
                    VirtualFile root = fileIndex.getSourceRootForFile(file);
                    if (root == null) {
                        root = fileIndex.getContentRootForFile(file);
                    }
                    if (root != null) {
                        path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
                    }
                }
            }
            return path;
        }

        private String trimPath(String path, Component component, String separator, int length) {
            FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
            int maxWidth = fontMetrics.stringWidth(path);
            if (maxWidth <= length) {
                this.myMaxWidth = Math.max(maxWidth, this.myMaxWidth);
                return path;
            }
            StringBuilder result = new StringBuilder(path);
            if (path.startsWith(separator)) {
                result.delete(0, 1);
            }
            String[] strings = result.toString().split(separator);
            result.replace(0, strings[0].length(), "...");
            for (int i = 1; i < strings.length; ++i) {
                String clipped = result.toString();
                int width = fontMetrics.stringWidth(clipped);
                if (width <= length) {
                    this.myMaxWidth = Math.max(width, this.myMaxWidth);
                    return clipped;
                }
                result.delete(4, 5 + strings[i].length());
            }
            return result.toString();
        }
    }
}

