/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.lang.jsp.JavaInJspProvider;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.jsp.IJspElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.impl.XmlBraceMatcher;

public class JspFileBraceMatcher
extends XmlBraceMatcher {
    private static final int JSP_TOKEN_GROUP = 3;
    private static final JavaInJspProvider ourJavaInfoProvider = JspWithOtherWorldIntegrationService.getInstance();

    public int getBraceTokenGroupId(IElementType tokenType) {
        if (tokenType instanceof IJspElementType) {
            return 3;
        }
        return super.getBraceTokenGroupId(tokenType);
    }

    public boolean areTagsCaseSensitive(FileType fileType, int braceGroupId) {
        if (braceGroupId == 3) {
            return true;
        }
        return super.areTagsCaseSensitive(fileType, braceGroupId);
    }

    protected boolean isStrictTagMatchingForFileType(FileType fileType) {
        return fileType == StdFileTypes.JSPX || super.isStrictTagMatchingForFileType(fileType);
    }

    public boolean isStructuralBrace(HighlighterIterator iterator, CharSequence text, FileType fileType) {
        if (!super.isStructuralBrace(iterator, text, fileType)) {
            return (fileType == StdFileTypes.JSP || fileType == StdFileTypes.JSPX) && JspFileBraceMatcher.isJspJspxStructuralBrace(iterator.getTokenType());
        }
        return true;
    }

    private static boolean isJspJspxStructuralBrace(IElementType tokenType) {
        return tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_TAG_END || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || ourJavaInfoProvider.isJavaStructuralBrace(tokenType);
    }

    public boolean isStrictTagMatching(FileType fileType, int braceGroupId) {
        switch (braceGroupId) {
            case 3: {
                return true;
            }
        }
        return super.isStrictTagMatching(fileType, braceGroupId);
    }

    protected boolean isWhitespace(IElementType tokenType1) {
        return tokenType1 == JspTokenType.JSP_WHITE_SPACE || super.isWhitespace(tokenType1);
    }

    protected boolean isFileTypeWithSingleHtmlTags(FileType fileType) {
        return fileType == StdFileTypes.JSP || super.isFileTypeWithSingleHtmlTags(fileType);
    }
}

