/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.jsp.JspBundle;
import com.intellij.jsp.impl.FileSubtypeSpecificDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileSubtypeSpecificElementDescriptor
extends XmlElementDescriptorImpl
implements Validator<XmlTag>,
FileSubtypeSpecificDescriptor {
    private final boolean mySpecificOnlyToTagAndTagxFile;
    private final boolean mySpecificOnlyToJspAndJspxFile;
    private final boolean mySpecificOnlyToXmlSyntax;
    @NonNls
    public static final String TAG_FILE_EXTENSION = "tag";
    @NonNls
    public static final String TAGX_FILE_EXTENSION = "tagx";

    FileSubtypeSpecificElementDescriptor(boolean _specificOnlyToTagAndTagxFile, boolean _specificOnlyToJspAndJspxFile, boolean _specificOnlyToXmlSyntax, PsiElement declaration) {
        super((XmlTag)declaration);
        this.mySpecificOnlyToJspAndJspxFile = _specificOnlyToJspAndJspxFile;
        this.mySpecificOnlyToTagAndTagxFile = _specificOnlyToTagAndTagxFile;
        this.mySpecificOnlyToXmlSyntax = _specificOnlyToXmlSyntax;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsp/impl/FileSubtypeSpecificElementDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jsp/impl/FileSubtypeSpecificElementDescriptor", "validate"));
        }
        super.validate(context, host);
        boolean isTagFileSpecificExtension = FileSubtypeSpecificElementDescriptor.isInTagFile((PsiElement)context);
        if (this.mySpecificOnlyToTagAndTagxFile && !isTagFileSpecificExtension || this.mySpecificOnlyToJspAndJspxFile && isTagFileSpecificExtension) {
            String message = this.mySpecificOnlyToTagAndTagxFile ? JspBundle.message("tag.should.be.used.in.tag.file.error.message", new Object[0]) : JspBundle.message("tag.should.not.be.used.in.tag.file.error.message", new Object[0]);
            host.addMessage((PsiElement)context, message, Validator.ValidationHost.ErrorType.ERROR);
        }
    }

    public static boolean isInTagFile(PsiElement context) {
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        String extension = containingFile.getVirtualFile() != null ? containingFile.getVirtualFile().getExtension() : null;
        return TAG_FILE_EXTENSION.equals(extension) || TAGX_FILE_EXTENSION.equals(extension);
    }

    private static boolean isJspFileSpecific(PsiElement context) {
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        return containingFile.getFileType() == StdFileTypes.JSP;
    }

    @Override
    public boolean isAcceptableInContext(PsiFile file) {
        boolean contextIsJspFile = FileSubtypeSpecificElementDescriptor.isJspFileSpecific((PsiElement)file);
        boolean contextIsJspxFile = file.getFileType() == StdFileTypes.JSPX;
        boolean contextIsTagFile = FileSubtypeSpecificElementDescriptor.isInTagFile((PsiElement)file);
        return this.mySpecificOnlyToJspAndJspxFile && (contextIsJspFile && !this.mySpecificOnlyToXmlSyntax || contextIsJspxFile && this.mySpecificOnlyToXmlSyntax) && !contextIsTagFile || this.mySpecificOnlyToTagAndTagxFile && contextIsTagFile || !this.mySpecificOnlyToTagAndTagxFile && !this.mySpecificOnlyToJspAndJspxFile && this.mySpecificOnlyToXmlSyntax == !contextIsJspFile;
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }
}

