/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxFileType
extends XmlLikeFileType {
    public static final JspxFileType INSTANCE = new JspxFileType();

    private JspxFileType() {
        super((Language)JSPXLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("JSPX" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileType", "getName"));
        }
        return "JSPX";
    }

    @NotNull
    public String getDescription() {
        String string = IdeBundle.message((String)"filetype.description.jspx", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        if ("jspx" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileType", "getDefaultExtension"));
        }
        return "jspx";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Jspx;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        String charset;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/highlighter/JspxFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/JspxFileType", "getCharset"));
        }
        Trinity guessed = LoadTextUtil.guessFromContent((VirtualFile)file, (byte[])content, (int)content.length);
        String string = charset = guessed != null && guessed.first != null ? ((Charset)guessed.first).name() : XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content);
        if (charset != null) {
            return charset;
        }
        charset = JspWithOtherWorldIntegrationService.getInstance().detectCharsetAsPerJspSpec(file, content, this.getLanguage());
        if (charset != null) {
            return charset;
        }
        return "UTF-8";
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/highlighter/JspxFileType", "extractCharsetFromFileContent"));
        }
        String name = XmlUtil.extractXmlEncodingFromProlog((CharSequence)content);
        Charset charset = CharsetToolkit.forName((String)name);
        if (charset != null) {
            return charset;
        }
        return JspWithOtherWorldIntegrationService.getInstance().detectCharsetAsPerJspSpec(project, file, content, this.getLanguage());
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

