/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.JavaInJspHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lexer.JspxHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.impl.source.jsp.el.ELHighlighter;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JspxFileHighlighter
extends SyntaxHighlighterBase {
    private static final JavaInJspHighlighter ourJavaHighlighter = JspWithOtherWorldIntegrationService.getInstance().createJavaHighlighter(null, null);
    private static final SyntaxHighlighter ourXmlHighlighter = new XmlFileHighlighter();

    @NotNull
    public Lexer getHighlightingLexer() {
        JspxHighlightingLexer jspxHighlightingLexer = new JspxHighlightingLexer();
        if (jspxHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileHighlighter", "getHighlightingLexer"));
        }
        return jspxHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == JspTokenType.JSP_WHITE_SPACE || ourJavaHighlighter.isMine(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = JspxFileHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_SCRIPTING_BACKGROUND, (TextAttributesKey[])ourJavaHighlighter.getTokenHighlights(tokenType));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = ourXmlHighlighter.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/highlighter/JspxFileHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        ELHighlighter elHighlighter = (ELHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)ELLanguage.INSTANCE, null, null);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(elHighlighter.getKeys1(), elHighlighter.getKeys2());
    }
}

