/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithTryCatchFix;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnhandledExceptionInJSP
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.ERROR_HANDLING_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"unhandled.exception.in.jsp.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnhandledExceptionInJSP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP", "getShortName"));
        }
        return "UnhandledExceptionInJSP";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP", "checkFile"));
        }
        if (!(file instanceof JspFile)) {
            return null;
        }
        JspFile jspFile = (JspFile)file;
        PsiFile errorPage = jspFile.getErrorPage();
        if (errorPage != null) {
            return null;
        }
        PsiClass aClass = jspFile.getJavaClass();
        if (aClass == null) {
            return null;
        }
        JspHolderMethod method = ((JspClass)aClass).getHolderMethod();
        SmartList problems = new SmartList();
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)problems, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$isOnTheFly = bl;
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                UnhandledExceptionInJSP.addUnhandledProblem((PsiElement)expression, manager, this.val$problems, this.val$isOnTheFly);
                super.visitMethodCallExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                UnhandledExceptionInJSP.addUnhandledProblem((PsiElement)expression, manager, this.val$problems, this.val$isOnTheFly);
                super.visitNewExpression(expression);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                UnhandledExceptionInJSP.addUnhandledProblem((PsiElement)statement, manager, this.val$problems, this.val$isOnTheFly);
                super.visitThrowStatement(statement);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void addUnhandledProblem(PsiElement element, InspectionManager manager, List<ProblemDescriptor> problems, boolean isOnTheFly) {
        List unhandledExceptions;
        PsiMethod parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
        if (parentMethod instanceof JspHolderMethod && !(unhandledExceptions = ExceptionUtil.getUnhandledExceptions((PsiElement)element)).isEmpty()) {
            String description = HighlightUtil.getUnhandledExceptionsDescriptor((Collection)unhandledExceptions);
            MySurroundWithTryCatchFix fix = new MySurroundWithTryCatchFix(element);
            problems.add(manager.createProblemDescriptor(element, description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static class MySurroundWithTryCatchFix
    extends LocalQuickFixOnPsiElement {
        private final SurroundWithTryCatchFix myAction;

        public MySurroundWithTryCatchFix(PsiElement element) {
            super(element);
            this.myAction = new SurroundWithTryCatchFix(element);
        }

        @NotNull
        public String getText() {
            String string = this.myAction.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "getFamilyName"));
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInspection/jsp/UnhandledExceptionInJSP$MySurroundWithTryCatchFix", "invoke"));
            }
            FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file.getVirtualFile());
            if (editor != null) {
                this.myAction.invoke(project, ((TextEditor)editor).getEditor(), file);
            }
        }
    }
}

