/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesToClassesFromDefaultPackageInJSPFileInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("inspection.references.to.classes.from.default.package.in.jsp.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("ReferencesToClassesFromDefaultPackagesInJSPFile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "getShortName"));
        }
        return "ReferencesToClassesFromDefaultPackagesInJSPFile";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/jsp/ReferencesToClassesFromDefaultPackageInJSPFileInspection", "checkFile"));
        }
        Language language = file.getViewProvider().getBaseLanguage();
        if (language != StdLanguages.JSP && language != StdLanguages.JSPX) {
            return null;
        }
        final ArrayList problems = new ArrayList();
        PsiFile javaFile = file.getViewProvider().getPsi(StdLanguages.JAVA);
        if (javaFile != file) {
            return null;
        }
        file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiPackageStatement packageStatement;
                PsiFile psiFile;
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiClass && (psiFile = resolved.getContainingFile()) instanceof PsiJavaFile && !psiFile.getViewProvider().getBaseLanguage().is((Language)NewJspLanguage.INSTANCE) && (packageStatement = ((PsiJavaFile)psiFile).getPackageStatement()) == null) {
                    ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)reference, JspBundle.message("inspection.problem.classes.from.the.default.package.must.not.be.referenced.from.jsp.file.text", new Object[0]), isOnTheFly, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    problems.add(problemDescriptor);
                }
                super.visitReferenceElement(reference);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }
}

