/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ELCompletionData;
import com.intellij.codeInsight.completion.ExtendedELFunctionInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELVariable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JspCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JspCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/JspCompletionContributor", "fillCompletionVariants"));
        }
        ASTNode node = parameters.getPosition().getNode();
        if (parameters.isExtendedCompletion() && node != null && node.getElementType() == ELTokenType.JSP_EL_IDENTIFIER) {
            result.stopHere();
            final PsiElement element = parameters.getPosition();
            PsiElement parent = element.getParent();
            if (parent != null) {
                JspFile jspFile;
                String namespacePrefix;
                final PsiElement call = parent.getParent();
                if (call instanceof ELFunctionCallExpression) {
                    ELVariable namespace = (ELVariable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ELVariable>(){

                        public ELVariable compute() {
                            return ((ELFunctionCallExpression)call).getNamespace();
                        }
                    });
                    namespacePrefix = namespace == null ? null : namespace.getText();
                    PsiReference reference = call.getReference();
                    if (namespace != null && reference != null) {
                        HashSet set = new HashSet();
                        new ELCompletionData().completeReference(reference, set, element, parameters.getOriginalFile());
                        for (LookupElement item : set) {
                            result.addElement(item);
                        }
                        return;
                    }
                } else {
                    namespacePrefix = null;
                }
                if ((jspFile = JspPsiUtil.getJspFile((PsiElement)call)) == null) {
                    return;
                }
                List names = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Pair<String, String>>>(){

                    public List<Pair<String, String>> compute() {
                        return JspManager.getInstance((Project)element.getProject()).getAvailableFunctions(jspFile);
                    }
                });
                for (Pair pair : names) {
                    String name = (String)pair.getFirst();
                    if (!result.getPrefixMatcher().prefixMatches(name)) continue;
                    LookupItem item = LookupItem.fromString((String)name);
                    String ns = (String)pair.getSecond();
                    ExtendedELFunctionInsertHandler insertHandler = new ExtendedELFunctionInsertHandler(name, ns, namespacePrefix);
                    if (!StringUtil.isEmpty((String)ns)) {
                        item.setAttribute(LookupItem.TAIL_TEXT_ATTR, (Object)(" (" + ns + ")"));
                        item.setAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR, (Object)"");
                    }
                    item.setInsertHandler((InsertHandler)insertHandler);
                    result.addElement((LookupElement)item);
                }
            }
        }
    }
}

