/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspImportsPanel
extends CodeStyleAbstractPanel {
    private final FileType myFileType;
    private JRadioButton myJspImportCommaSeparated;
    private JRadioButton myJspOneImportPerDirective;
    private final JPanel myImportsPanel;

    protected JspImportsPanel(@NotNull CodeStyleSettings settings, @NotNull FileType fileType) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/JspImportsPanel", "<init>"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/application/options/JspImportsPanel", "<init>"));
        }
        super(settings);
        this.myFileType = fileType;
        this.myImportsPanel = this.createJspImportLayoutPanel();
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @NotNull
    protected FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JspImportsPanel", "getFileType"));
        }
        return fileType;
    }

    @Nullable
    protected String getPreviewText() {
        return null;
    }

    protected String getTabTitle() {
        return "Imports";
    }

    private JPanel createJspImportLayoutPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myJspImportCommaSeparated = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.comma.separated.import.list", (Object[])new Object[0]));
        this.myJspOneImportPerDirective = new JRadioButton(ApplicationBundle.message((String)"radio.prefer.one.import.statement.per.page.directive", (Object[])new Object[0]));
        buttonGroup.add(this.myJspImportCommaSeparated);
        buttonGroup.add(this.myJspOneImportPerDirective);
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.add((Component)this.myJspImportCommaSeparated, "North");
        btnPanel.add((Component)this.myJspOneImportPerDirective, "Center");
        final MultiLineLabel commaSeparatedLabel = new MultiLineLabel("<% page import=\"com.company.Boo, com.company.Far\"%>");
        final MultiLineLabel oneImportPerDirectiveLabel = new MultiLineLabel("<% page import=\"com.company.Boo\"%>\n<% page import=\"com.company.Far\"%>");
        final JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 10, 0, 0), (Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.preview", (Object[])new Object[0]), (boolean)false)));
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.add((Component)btnPanel, "North");
        resultPanel.add((Component)labelPanel, "Center");
        resultPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.jsp.imports.layout", (Object[])new Object[0]), (boolean)true, (Insets)new Insets(10, 15, 0, 0)));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isComma = JspImportsPanel.this.myJspImportCommaSeparated.isSelected();
                labelPanel.removeAll();
                labelPanel.add((Component)(isComma ? commaSeparatedLabel : oneImportPerDirectiveLabel), "North");
                labelPanel.repaint();
                labelPanel.revalidate();
            }
        };
        this.myJspImportCommaSeparated.addActionListener(actionListener);
        this.myJspOneImportPerDirective.addActionListener(actionListener);
        return resultPanel;
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = this.myJspImportCommaSeparated.isSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        return settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST != this.myJspImportCommaSeparated.isSelected();
    }

    @Nullable
    public JComponent getPanel() {
        return this.myImportsPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        if (settings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST) {
            this.myJspImportCommaSeparated.doClick();
        } else {
            this.myJspOneImportPerDirective.doClick();
        }
    }
}

