/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.spring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.velocity.VtlGlobalMacroProvider;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringGlobalMacroProvider
extends VtlGlobalMacroProvider {
    private static final String SPRING_VM_PACKAGE = "org.springframework.web.servlet.view.velocity";
    private static final String SPRING_VM = "spring.vm";

    @Override
    @NotNull
    public Collection<VtlMacro> getGlobalMacros(@NotNull VtlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/spring/SpringGlobalMacroProvider", "getGlobalMacros"));
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)file.getProject()).findPackage(SPRING_VM_PACKAGE);
        if (aPackage != null) {
            for (PsiDirectory directory : aPackage.getDirectories()) {
                PsiFile springVmFile = directory.findFile(SPRING_VM);
                if (!(springVmFile instanceof VtlFile)) continue;
                Set<VtlMacro> set = ((VtlFile)springVmFile).getDefinedMacros();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/spring/SpringGlobalMacroProvider", "getGlobalMacros"));
                }
                return set;
            }
        }
        Set<VtlMacro> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/spring/SpringGlobalMacroProvider", "getGlobalMacros"));
        }
        return set;
    }
}

