/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.psi.reference.VelocityNamingUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityStyleBeanProperty
extends BeanProperty {
    private String myName;

    protected VelocityStyleBeanProperty(@NotNull PsiMethod method, @NotNull String name) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityStyleBeanProperty", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/reference/VelocityStyleBeanProperty", "<init>"));
        }
        super(method);
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VelocityStyleBeanProperty", "getName"));
        }
        return string;
    }

    public PsiMethod getGetter() {
        PsiMethod method = this.getMethod();
        if (VelocityNamingUtil.isPropertyGetter(method)) {
            return method;
        }
        return VelocityNamingUtil.findPropertyGetter(method.getContainingClass(), this.getName());
    }

    public PsiMethod getSetter() {
        PsiMethod method = this.getMethod();
        if (VelocityNamingUtil.isPropertySetter(method)) {
            return method;
        }
        return VelocityNamingUtil.findPropertySetter(method.getContainingClass(), this.getName());
    }

    public void setName(String newName) throws IncorrectOperationException {
        super.setName(newName);
        this.myName = newName;
    }

    @NotNull
    public PsiType getPropertyType() {
        PsiType type = VelocityNamingUtil.getPropertyType(this.getMethod());
        assert (type != null);
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/reference/VelocityStyleBeanProperty", "getPropertyType"));
        }
        return psiType;
    }

    @Nullable
    public static BeanProperty createVelocityStyleBeanProperty(@NotNull PsiMethod method, @Nullable String name) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityStyleBeanProperty", "createVelocityStyleBeanProperty"));
        }
        if (name == null) {
            return null;
        }
        return VelocityNamingUtil.isPropertyAccessor(method) || VelocityNamingUtil.isGetByStringOrByObjectMethod(method) ? new VelocityStyleBeanProperty(method, name) : null;
    }
}

