/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityNamingUtil {
    private VelocityNamingUtil() {
    }

    public static boolean isWaitOrNotifyOfObject(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "isWaitOrNotifyOfObject"));
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null || !"java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        String name = method.getName();
        return "wait".equals(name) || "notify".equals(name) || "notifyAll".equals(name);
    }

    public static boolean isPropertyGetter(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "isPropertyGetter"));
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
                return false;
            }
        } else if (methodName.startsWith("is")) {
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                return false;
            }
        } else {
            return false;
        }
        return method.getParameterList().getParametersCount() == 0;
    }

    public static boolean isGetByStringOrByObjectMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "isGetByStringOrByObjectMethod"));
        }
        String methodName = method.getName();
        if (!"get".equals(methodName)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = parameterList.getParameters()[0];
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        PsiClassType javaLangString = factory.createTypeByFQClassName("java.lang.String", method.getResolveScope());
        if (parameter.getType().isAssignableFrom((PsiType)javaLangString)) {
            return true;
        }
        PsiClassType javaLangObject = factory.createTypeByFQClassName("java.lang.Object", method.getResolveScope());
        return parameter.getType().isAssignableFrom((PsiType)javaLangObject);
    }

    public static boolean isPropertySetter(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "isPropertySetter"));
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > "set".length() && method.getParameterList().getParametersCount() == 1 && (method.getReturnType() == null || PsiType.VOID.equals((Object)method.getReturnType()));
    }

    public static boolean isPropertyAccessor(PsiMethod method) {
        return VelocityNamingUtil.isPropertyGetter(method) || VelocityNamingUtil.isPropertySetter(method);
    }

    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor, boolean firstCharInLowerCase) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "getPropertyNameFromAccessor"));
        }
        if (VelocityNamingUtil.isPropertySetter(accessor)) {
            return VelocityNamingUtil.adjustFirstCharCase(VelocityNamingUtil.getPropertyNameFromSetter(accessor), firstCharInLowerCase);
        }
        if (VelocityNamingUtil.isPropertyGetter(accessor)) {
            return VelocityNamingUtil.adjustFirstCharCase(VelocityNamingUtil.getPropertyNameFromGetter(accessor), firstCharInLowerCase);
        }
        return null;
    }

    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "getPropertyNameFromAccessor"));
        }
        if (VelocityNamingUtil.isPropertySetter(accessor)) {
            return VelocityNamingUtil.getPropertyNameFromSetter(accessor);
        }
        if (VelocityNamingUtil.isPropertyGetter(accessor)) {
            return VelocityNamingUtil.getPropertyNameFromGetter(accessor);
        }
        return null;
    }

    public static String adjustFirstCharCase(@NotNull String name, boolean lowerCase) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "adjustFirstCharCase"));
        }
        char[] chars = name.toCharArray();
        chars[0] = lowerCase ? StringUtil.toLowerCase((char)chars[0]) : StringUtil.toUpperCase((char)chars[0]);
        return new String(chars);
    }

    public static String getPropertyName(String methodName, boolean firstCharInLowerCase) {
        String propName;
        if (methodName.startsWith("get")) {
            propName = methodName.substring("get".length());
        } else if (methodName.startsWith("set")) {
            propName = methodName.substring("set".length());
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring("is".length());
        } else {
            return null;
        }
        return VelocityNamingUtil.adjustFirstCharCase(propName, firstCharInLowerCase);
    }

    private static String getPropertyNameFromGetter(@NotNull PsiMethod getter) {
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "getPropertyNameFromGetter"));
        }
        String methodName = getter.getName();
        int prefixLength = methodName.startsWith("get") ? "get".length() : "is".length();
        return methodName.substring(prefixLength);
    }

    private static String getPropertyNameFromSetter(@NotNull PsiMethod setter) {
        if (setter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setter", "com/intellij/velocity/psi/reference/VelocityNamingUtil", "getPropertyNameFromSetter"));
        }
        return setter.getName().substring("set".length());
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName) {
        return VelocityNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil$1", "extractPropertyName"));
                }
                return VelocityNamingUtil.isPropertyGetter(method) ? VelocityNamingUtil.getPropertyNameFromGetter(method) : null;
            }
        });
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName) {
        return VelocityNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil$2", "extractPropertyName"));
                }
                return VelocityNamingUtil.isPropertySetter(method) ? VelocityNamingUtil.getPropertyNameFromSetter(method) : null;
            }
        });
    }

    @Nullable
    private static PsiMethod findPropertyAccessor(PsiClass aClass, String propertyName, PropertyNameExtractor extractor) {
        if (aClass == null) {
            return null;
        }
        PsiMethod found = null;
        String propertyNameWithoutFirstChar = propertyName.substring(1);
        for (PsiMethod method : aClass.getAllMethods()) {
            String wouldBePropertyName = extractor.extractPropertyName(method);
            if (wouldBePropertyName == null || !propertyNameWithoutFirstChar.equals(wouldBePropertyName.substring(1))) continue;
            if (wouldBePropertyName.charAt(0) == propertyName.charAt(0)) {
                return method;
            }
            if (StringUtil.toLowerCase((char)wouldBePropertyName.charAt(0)) != StringUtil.toLowerCase((char)propertyName.charAt(0))) continue;
            found = method;
        }
        return found;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMethod psiMethod) {
        if (VelocityNamingUtil.isPropertyGetter(psiMethod)) {
            return psiMethod.getReturnType();
        }
        if (VelocityNamingUtil.isPropertySetter(psiMethod)) {
            return psiMethod.getParameterList().getParameters()[0].getType();
        }
        return null;
    }

    public static String[] suggestGetterNames(String propertyName) {
        String upperCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, false);
        String lowerCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, true);
        return new String[]{"is" + upperCaseName, "get" + upperCaseName, "is" + lowerCaseName, "get" + lowerCaseName};
    }

    public static String[] suggestSetterNames(String propertyName) {
        String upperCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, false);
        String lowerCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, true);
        return new String[]{"set" + upperCaseName, "set" + lowerCaseName};
    }

    private static interface PropertyNameExtractor {
        @Nullable
        public String extractPropertyName(@NotNull PsiMethod var1);
    }
}

