/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.parsers;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlCompositeElementType;
import com.intellij.velocity.psi.VtlCompositeStarterTokenType;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.parsers.ListHandler;
import com.intellij.velocity.psi.parsers.VtlParser;

public abstract class CompositeBodyParser {
    static final CompositeEndDetector COMMON_END_DETECTOR = new CompositeEndDetector();
    private static final Key<Integer> FOREACH_COUNTER = Key.create((String)"FOREACH_COUNTER");

    public abstract void parseBody(PsiBuilder var1, PsiBuilder.Marker var2);

    protected static void finishCompositeWithEnd(PsiBuilder builder, PsiBuilder.Marker bodyMarker, VtlCompositeElementType bodyType) {
        if (builder.getTokenType() != VtlElementTypes.SHARP_END) {
            bodyMarker.error(VelocityBundle.message("token.expected", "#end"));
        } else {
            builder.advanceLexer();
            bodyMarker.done((IElementType)bodyType);
        }
    }

    protected static boolean assertToken(PsiBuilder builder, IElementType expected) {
        if (builder.getTokenType() != expected) {
            builder.error(VelocityBundle.message("token.expected", expected));
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    protected static boolean assertToken(PsiBuilder builder, IElementType expected, VtlCompositeElementType compositeElementType) {
        if (builder.getTokenType() != expected) {
            builder.error(VelocityBundle.message("token.expected", expected));
            return false;
        }
        PsiBuilder.Marker start = builder.mark();
        builder.advanceLexer();
        start.done((IElementType)compositeElementType);
        return true;
    }

    protected static boolean consumeTokenIfPresent(PsiBuilder builder, IElementType tokenType) {
        if (builder.getTokenType() == tokenType) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    protected static boolean parseArgumentList(PsiBuilder builder, boolean requireSeparator, boolean allowEmpty) {
        if (!CompositeBodyParser.assertToken(builder, VtlElementTypes.LEFT_PAREN)) {
            builder.error(VelocityBundle.message("argument.list.expected", new Object[0]));
            return false;
        }
        PsiBuilder.Marker listMarker = builder.mark();
        if (builder.getTokenType() != VtlElementTypes.RIGHT_PAREN) {
            VtlParser.parseList(builder, ListHandler.GENERAL_LIST_HANDLER, requireSeparator);
        } else if (!allowEmpty) {
            builder.error(VelocityBundle.message("argument.list.expected", new Object[0]));
        }
        listMarker.done((IElementType)VtlElementTypes.ARGUMENT_LIST);
        CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_PAREN);
        return true;
    }

    protected static boolean parseConditionalExpression(PsiBuilder builder) {
        if (!CompositeBodyParser.assertToken(builder, VtlElementTypes.LEFT_PAREN)) {
            return false;
        }
        VtlParser.parseBinaryExpression(builder);
        CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_PAREN);
        return true;
    }

    static void assertVariable(PsiBuilder builder, VtlCompositeElementType elementType, String errorMsg) {
        IElementType variableStarter = builder.getTokenType();
        builder.advanceLexer();
        PsiBuilder.Marker variable = builder.mark();
        if (variableStarter != VtlElementTypes.START_REFERENCE && variableStarter != VtlElementTypes.START_REF_FORMAL) {
            variable.drop();
            builder.error(errorMsg);
            return;
        }
        boolean identFound = CompositeBodyParser.assertToken(builder, VtlElementTypes.IDENTIFIER);
        if (variableStarter == VtlElementTypes.START_REF_FORMAL) {
            CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACE);
        }
        if (identFound) {
            variable.done((IElementType)elementType);
        } else {
            variable.drop();
        }
    }

    static boolean noForeachStarted(PsiBuilder builder) {
        return builder.getUserData(FOREACH_COUNTER) == null;
    }

    static void incrementForeachCounter(PsiBuilder builder) {
        Integer counter = (Integer)builder.getUserData(FOREACH_COUNTER);
        if (counter == null) {
            counter = 0;
        }
        builder.putUserData(FOREACH_COUNTER, (Object)(counter + 1));
    }

    static void decrementForeachCounter(PsiBuilder builder) {
        Integer counter = (Integer)builder.getUserData(FOREACH_COUNTER);
        assert (counter != null);
        counter = counter > 1 ? Integer.valueOf(counter - 1) : null;
        builder.putUserData(FOREACH_COUNTER, (Object)counter);
    }

    static class CompositeEndDetector {
        CompositeEndDetector() {
        }

        public boolean isCompositeFinished(PsiBuilder builder) {
            return builder.getTokenType() == VtlElementTypes.SHARP_END;
        }

        public boolean isTokenInvalid(IElementType tokenType) {
            if (tokenType == VtlElementTypes.TEMPLATE_TEXT || tokenType == VtlElementTypes.SHARP_STOP) {
                return false;
            }
            if (tokenType == VtlElementTypes.SHARP_ELSE || tokenType == VtlElementTypes.SHARP_ELSEIF) {
                return true;
            }
            return !(tokenType instanceof VtlCompositeStarterTokenType);
        }
    }
}

