/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlVariable;
import com.intellij.velocity.psi.directives.VtlAssignment;
import com.intellij.velocity.psi.directives.VtlForeach;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixedNameVariable
extends RenameableFakePsiElement
implements VtlVariable {
    public static final Key<FixedNameVariable> SCOPE = Key.create((String)"VtlScope");
    private final String myName;
    @Nullable
    private final String myTypeName;
    private final PsiElement myParent;
    private final boolean myScope;

    FixedNameVariable(PsiElement parent, @NotNull String name, @Nullable String typeName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/directives/FixedNameVariable", "<init>"));
        }
        this(parent, name, typeName, false);
    }

    public FixedNameVariable(PsiElement parent, @NotNull String name, boolean scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/directives/FixedNameVariable", "<init>"));
        }
        this(parent, name, null, scope);
    }

    FixedNameVariable(PsiElement parent, @NotNull String name, @Nullable String typeName, boolean scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/directives/FixedNameVariable", "<init>"));
        }
        super((PsiElement)parent.getContainingFile());
        this.myParent = parent;
        this.myName = name;
        this.myTypeName = typeName;
        this.myScope = scope;
    }

    public PsiElement getParent() {
        return this.getRealScope().myParent;
    }

    public FixedNameVariable getRealScope() {
        return this.myParent instanceof FixedNameVariable ? (FixedNameVariable)this.myParent : this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myParent.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/FixedNameVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/FixedNameVariable", "getName"));
        }
        return string;
    }

    public String getTypeName() {
        return "Variable";
    }

    public boolean isWritable() {
        return false;
    }

    public PsiElement setName(@NotNull @NonNls String s) throws IncorrectOperationException {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/velocity/psi/directives/FixedNameVariable", "setName"));
        }
        throw new IncorrectOperationException(VelocityBundle.message("operation.not.allowed", new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FixedNameVariable)) {
            return false;
        }
        FixedNameVariable that = (FixedNameVariable)o;
        if (this.myScope != that.myScope) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myParent.equals(that.myParent)) {
            return false;
        }
        return !(this.myTypeName != null ? !this.myTypeName.equals(that.myTypeName) : that.myTypeName != null);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myTypeName != null ? this.myTypeName.hashCode() : 0);
        result = 31 * result + this.myParent.hashCode();
        result = 31 * result + (this.myScope ? 1 : 0);
        return result;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        if (this.myTypeName == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName(this.myTypeName, this.getResolveScope());
    }

    @Override
    @Nullable
    public PsiComment getDocComment() {
        return null;
    }

    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/velocity/psi/directives/FixedNameVariable", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/directives/FixedNameVariable", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/velocity/psi/directives/FixedNameVariable", "processDeclarations"));
        }
        if (this.myScope) {
            FixedNameVariable realScope = this.getRealScope();
            if (!PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new BaseScopeProcessor(){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/psi/directives/FixedNameVariable$1", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/directives/FixedNameVariable$1", "execute"));
                    }
                    return !(element instanceof VtlAssignment.AssignedVariable) || processor.execute(element, state);
                }
            }, (PsiElement)place, null, (ResolveState)ResolveState.initial().put(SCOPE, (Object)realScope))) {
                return false;
            }
            Class<?> parentClass = this.getParent().getClass();
            if (!this.processInDelegateScope(processor, state, lastParent, place, PsiTreeUtil.getParentOfType((PsiElement)this.myParent, parentClass), "parent")) {
                return false;
            }
            if (!this.processInDelegateScope(processor, state, lastParent, place, PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myParent, parentClass), "topmost")) {
                return false;
            }
            if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "depth", "java.lang.Integer"), state)) {
                return false;
            }
            if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "replaced", null), state)) {
                return false;
            }
            if (this.getParent() instanceof VtlForeach) {
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "count", "java.lang.Integer"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "index", "java.lang.Integer"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "hasNext", "java.lang.Boolean"), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "first", null), state)) {
                    return false;
                }
                if (!processor.execute((PsiElement)new FixedNameVariable((PsiElement)realScope, "last", null), state)) {
                    return false;
                }
            }
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private boolean processInDelegateScope(final PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, PsiElement next, final String accessor) {
        return next == null || next.processDeclarations((PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/psi/directives/FixedNameVariable$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/psi/directives/FixedNameVariable$2", "execute"));
                }
                if (element instanceof FixedNameVariable && ((FixedNameVariable)element).myName.equals(FixedNameVariable.this.myName)) {
                    return processor.execute((PsiElement)new FixedNameVariable(element, accessor, true), state);
                }
                return true;
            }
        }, state, lastParent, place);
    }

    public String toString() {
        return "FixedNameVariable{myName='" + this.myName + '\'' + ", myTypeName='" + this.myTypeName + '\'' + ", myScope=" + this.myScope + '}';
    }

    @Nullable
    public static FixedNameVariable getReferenceScope(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/velocity/psi/directives/FixedNameVariable", "getReferenceScope"));
        }
        VtlReferenceExpression qualifier = (VtlReferenceExpression)ref.getQualifier();
        PsiElement resolve = qualifier == null ? null : qualifier.resolve();
        return resolve instanceof FixedNameVariable && ((FixedNameVariable)resolve).myScope ? (FixedNameVariable)resolve : null;
    }

    @NotNull
    public PsiElement getTargetElement() {
        PsiElement macro;
        PsiElement navigationElement;
        if (this.myScope && (navigationElement = this.getNavigationElement()) instanceof VtlMacroCall && (macro = ((VtlMacroCall)navigationElement).getReferenceExpression().resolve()) != null) {
            PsiElement psiElement = macro;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/FixedNameVariable", "getTargetElement"));
            }
            return psiElement;
        }
        FixedNameVariable fixedNameVariable = this;
        if (fixedNameVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/directives/FixedNameVariable", "getTargetElement"));
        }
        return fixedNameVariable;
    }
}

