/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.VtlElementTypes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VtlNamedElement
extends VtlCompositeElement
implements PsiNamedElement {
    public VtlNamedElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/VtlNamedElement", "<init>"));
        }
        super(node);
    }

    @Nullable
    public final String getName() {
        PsiElement e = this.getNameElement();
        if (e == null) {
            return null;
        }
        return e.getText();
    }

    @Nullable
    protected PsiElement getNameElement() {
        return this.findChildByType(VtlElementTypes.IDENTIFIER);
    }

    @NotNull
    public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/velocity/psi/VtlNamedElement", "setName"));
        }
        PsiElement nameElement = this.getNameElement();
        assert (nameElement != null);
        PsiElement newNameElement = PsiUtil.createIdentifierElement(this.getProject(), name);
        nameElement.replace(newNameElement);
        VtlNamedElement vtlNamedElement = this;
        if (vtlNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/psi/VtlNamedElement", "setName"));
        }
        return vtlNamedElement;
    }

    public int getTextOffset() {
        PsiElement e = this.getNameElement();
        if (e == null) {
            return super.getTextOffset();
        }
        return e.getTextOffset();
    }
}

