/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.directives.VtlMacroImpl;
import com.intellij.velocity.psi.directives.VtlParse;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlMacroAnnotator
implements Annotator {
    @NonNls
    private static final String V_IDENTIFIER = "([a-zA-Z_][a-zA-Z_0-9-]*)";
    @NonNls
    private static final Pattern WOULD_BE_MACRO_CALL_PATTERN = Pattern.compile("(#([a-zA-Z_][a-zA-Z_0-9-]*))|(#\\{([a-zA-Z_][a-zA-Z_0-9-]*)\\})");

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/VtlMacroAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/velocity/inspections/VtlMacroAnnotator", "annotate"));
        }
        if (element instanceof VtlMacroImpl) {
            TextRange range;
            VtlMacroImpl macro = (VtlMacroImpl)element;
            VtlFile file = macro.getContainingFile();
            String macroName = macro.getName();
            if (macroName != null && file.getNumberOfMacros(macroName) > 1) {
                range = macro.getNameElementRange();
                assert (range != null);
                holder.createErrorAnnotation(range, VelocityBundle.message("macro.is.already.defined", macroName, file.getName()));
            }
            if ((range = macro.getBodyRange()) != null && StringUtil.isEmptyOrSpaces((String)range.substring(macro.getText()))) {
                holder.createWarningAnnotation(macro.getLastChild(), "Macro body expected");
            }
        } else if (element instanceof VtlParameterDeclaration) {
            VtlParameterDeclaration param = (VtlParameterDeclaration)element;
            String paramName = param.getName();
            if (paramName == null) {
                return;
            }
            for (PsiElement sibling = param.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                if (!(sibling instanceof VtlParameterDeclaration) || !paramName.equals(((VtlParameterDeclaration)sibling).getName())) continue;
                String msg = VelocityBundle.message("duplicate.parameter.name", paramName);
                holder.createErrorAnnotation(param.getTextRange(), msg);
                holder.createErrorAnnotation(sibling.getTextRange(), msg);
            }
        } else if (element instanceof VtlParse) {
            VtlParse parse = (VtlParse)element;
            VtlFile parsedFile = parse.resolveFile();
            if (parsedFile == null) {
                return;
            }
            VtlArgumentList argumentList = parse.getArgumentList();
            assert (argumentList != null);
            VtlExpression parsedFileElement = argumentList.getArguments()[0];
            VtlFile containingFile = parse.getContainingFile();
            for (String macroName : containingFile.getDefinedMacroNames()) {
                if (parsedFile.getNumberOfMacros(macroName) <= 0) continue;
                String msg = VelocityBundle.message("macro.declaration.will.be.ignored", macroName, containingFile.getName(), parsedFile.getName());
                holder.createWarningAnnotation((PsiElement)parsedFileElement, msg);
            }
        } else {
            ASTNode node = element.getNode();
            if (node == null || node.getElementType() != VtlElementTypes.TEMPLATE_TEXT) {
                return;
            }
            Matcher matcher = WOULD_BE_MACRO_CALL_PATTERN.matcher(node.getText());
            if (!matcher.find()) {
                return;
            }
            PsiFile file = element.getContainingFile();
            if (!(file instanceof VtlFile)) {
                return;
            }
            VtlFile vtlFile = (VtlFile)file;
            do {
                int index;
                String macroName;
                BaseScopeProcessor processor;
                if (vtlFile.processAllMacrosInScope((PsiScopeProcessor)(processor = new BaseScopeProcessor(macroName = matcher.group(index = matcher.start(2) != -1 ? 2 : 4)){
                    final /* synthetic */ String val$macroName;
                    {
                        this.val$macroName = string;
                    }

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/VtlMacroAnnotator$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/velocity/inspections/VtlMacroAnnotator$1", "execute"));
                        }
                        return !(element instanceof VtlMacro) || !this.val$macroName.equals(((VtlMacro)element).getName());
                    }
                }), ResolveState.initial())) continue;
                TextRange range = new TextRange(matcher.start(), matcher.end()).shiftRight(element.getTextOffset());
                holder.createErrorAnnotation(range, VelocityBundle.message("will.be.considered.as.macro.call", new Object[0]));
            } while (matcher.find());
        }
    }
}

