/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class StringCollectionExpression
extends Expression {
    private final Collection<String> myAllOptions;
    private final Function<String, LookupElement> myMapper;

    public StringCollectionExpression(@NotNull Collection<String> allOptions) {
        if (allOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOptions", "com/intellij/velocity/inspections/StringCollectionExpression", "<init>"));
        }
        this.myAllOptions = allOptions;
        this.myMapper = option -> LookupElementBuilder.create((String)option);
    }

    public StringCollectionExpression(@NotNull Collection<String> allOptions, @NotNull Function<String, LookupElement> mapper) {
        if (allOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allOptions", "com/intellij/velocity/inspections/StringCollectionExpression", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/velocity/inspections/StringCollectionExpression", "<init>"));
        }
        this.myAllOptions = allOptions;
        this.myMapper = mapper;
    }

    public Result calculateResult(ExpressionContext context) {
        return this.calculateQuickResult(context);
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.myAllOptions.size() == 1 ? new TextResult(this.myAllOptions.iterator().next()) : null;
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return (LookupElement[])ContainerUtil.map2Array(this.myAllOptions, LookupElement.class, this.myMapper);
    }
}

