/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.inspections.StringCollectionExpression;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DefineMacroLibraryRefIntention
extends DefineInCommentIntention {
    public DefineMacroLibraryRefIntention(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "<init>"));
        }
        super(text, VelocityBundle.message("add.macro.library.ref.fix.name", new Object[0]));
    }

    @Override
    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "isAvailable"));
        }
        return ref.getParent() instanceof VtlMacroCall && Util.canSetVelocityProperties(ref.getContainingFile());
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, @NotNull PsiElement element, String relativePath, @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "prepareTemplate"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "prepareTemplate"));
        }
        if (fileToInsertComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToInsertComment", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "prepareTemplate"));
        }
        assert (element instanceof VtlReferenceExpression);
        List<String> allFiles = Util.collectFilePaths(element, psiFile -> {
            VtlFile vtlFile;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "lambda$prepareTemplate$0"));
            }
            if (fileToInsertComment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToInsertComment", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention", "lambda$prepareTemplate$0"));
            }
            PsiFile file = psiFile.getViewProvider().getPsi((Language)VtlLanguage.INSTANCE);
            if (file instanceof VtlFile && (vtlFile = (VtlFile)file).getNumberOfMacros(((VtlReferenceExpression)element).getReferenceName()) > 0) {
                return PsiUtil.getRelativePath(fileToInsertComment, (PsiFile)vtlFile);
            }
            return null;
        });
        template.addTextSegment("#* @vtlmacrolibrary path=\"");
        StringCollectionExpression pathExpression = new StringCollectionExpression(allFiles);
        template.addVariable("PATH", (Expression)pathExpression, (Expression)pathExpression, true);
        String fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment("\"" + fileRef + " *#\n");
        template.addEndVariable();
    }

    public static class ModuleWide
    extends DefineMacroLibraryRefIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.macro.library.ref.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor, false);
        }
    }

    public static class LocalExternal
    extends DefineMacroLibraryRefIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.macro.library.ref.fix.name.external", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention$LocalExternal", "invoke"));
            }
            this.chooseTargetFile(file, editor, true);
        }
    }

    public static class Local
    extends DefineMacroLibraryRefIntention {
        public Local() {
            super(VelocityBundle.message("add.macro.library.ref.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineMacroLibraryRefIntention$Local", "invoke"));
            }
            this.defineInComment(editor, file, file, false);
        }
    }
}

