/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCallExpression;
import com.intellij.velocity.psi.VtlCallable;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlMethodCallExpression;
import com.intellij.velocity.psi.VtlVariable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlParameterInfoHandler
implements ParameterInfoHandler<VtlArgumentList, VtlCallable> {
    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(VtlCallable callable, ParameterInfoContext context) {
        return new Object[]{callable};
    }

    public VtlArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlParameterInfoHandler", "findElementForParameterInfo"));
        }
        return VtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    @Nullable
    private static VtlArgumentList findArgumentList(ParameterInfoContext context) {
        PsiFile file = context.getFile();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(context.getEditor().getDocument());
        PsiElement elementAt = file.getViewProvider().findElementAt(context.getOffset(), (Language)VtlLanguage.INSTANCE);
        if (elementAt == null) {
            return null;
        }
        VtlCallExpression call = (VtlCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, VtlCallExpression.class);
        if (call == null) {
            return null;
        }
        return call.findArgumentList();
    }

    public void showParameterInfo(@NotNull VtlArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/VtlParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlParameterInfoHandler", "showParameterInfo"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof VtlCallExpression)) {
            return;
        }
        Object[] candidates = ((VtlCallExpression)parent).getCallableCandidates();
        if (candidates.length == 0) {
            return;
        }
        context.setItemsToShow(candidates);
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public VtlArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return VtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull VtlArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/velocity/VtlParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlParameterInfoHandler", "updateParameterInfo"));
        }
        assert (argumentList.isValid());
        PsiElement prevOwner = context.getParameterOwner();
        int prevOwnerTextOffset = prevOwner == null ? 0 : prevOwner.getTextOffset();
        context.setParameterOwner((PsiElement)argumentList);
        if (prevOwnerTextOffset != 0 && prevOwnerTextOffset != argumentList.getTextOffset()) {
            context.removeHint();
            context.setCurrentParameter(-1);
            return;
        }
        int offset = context.getEditor().getCaretModel().getOffset() - argumentList.getTextRange().getStartOffset();
        if (offset < 0) {
            context.setCurrentParameter(-1);
            return;
        }
        int index = 0;
        for (ASTNode child : argumentList.getNode().getChildren(null)) {
            PsiElement psiChild = child.getPsi();
            offset -= child.getTextLength();
            if (!(psiChild instanceof VtlExpression)) continue;
            if (offset <= 0) break;
            ++index;
        }
        context.setCurrentParameter(index);
    }

    public String getParameterCloseChars() {
        return ", )";
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void updateUI(VtlCallable callable, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/velocity/VtlParameterInfoHandler", "updateUI"));
        }
        PsiElement list = context.getParameterOwner();
        if (!list.isValid()) {
            return;
        }
        int index = context.getCurrentParameterIndex();
        boolean applicable = VtlParameterInfoHandler.isApplicable(callable, list, index);
        int highlightStart = -1;
        int highlightEnd = -1;
        StringBuilder sb = new StringBuilder();
        VtlVariable[] variables = callable.getParameters();
        boolean isMacro = callable instanceof VtlMacro;
        String delimiter = isMacro ? " " : ", ";
        for (int i = 0; i < variables.length; ++i) {
            VtlVariable variable;
            PsiType type;
            if (i > 0) {
                sb.append(delimiter);
            }
            if (i == index) {
                highlightStart = sb.length();
            }
            if ((type = (variable = variables[i]).getPsiType()) != null) {
                sb.append(type.getPresentableText()).append(" ");
            }
            if (isMacro) {
                sb.append('$');
            }
            sb.append(variable.getName());
            if (i != index) continue;
            highlightEnd = sb.length();
        }
        if (variables.length == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        boolean deprecated = callable.isDeprecated();
        context.setupUIComponentPresentation(sb.toString(), highlightStart, highlightEnd, !applicable, deprecated, false, context.getDefaultParameterColor());
    }

    private static boolean isApplicable(VtlCallable callable, PsiElement list, int index) {
        boolean applicable = callable.getParameters().length > index || index == 0 && callable.getParameters().length == 0;
        PsiElement parent = list.getParent();
        if (applicable && parent instanceof VtlMethodCallExpression) {
            VtlExpression[] arguments = ((VtlMethodCallExpression)parent).getArgumentList().getArguments();
            VtlVariable[] parameters = callable.getParameters();
            for (int i = 0; i < index; ++i) {
                PsiType paramType = parameters[i].getPsiType();
                PsiType argType = arguments[i].getPsiType();
                if (argType == null && paramType == null) continue;
                paramType = PsiUtil.getBoxedType(paramType, list);
                if (argType != null && paramType != null && TypeConversionUtil.areTypesConvertible((PsiType)argType, (PsiType)paramType)) continue;
                return false;
            }
        }
        return applicable;
    }
}

