/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WildcardPattern
extends AopPsiTypePattern {
    @Nullable
    private final AopPsiTypePattern myBound;
    private final boolean mySuper;

    public WildcardPattern(AopPsiTypePattern bound, boolean aSuper) {
        this.myBound = bound;
        this.mySuper = aSuper;
    }

    @Nullable
    public AopPsiTypePattern getBound() {
        return this.myBound;
    }

    public boolean isSuper() {
        return this.mySuper;
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/WildcardPattern", "accepts"));
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType bound = wildcardType.getBound();
            if (this.myBound == null) {
                return bound == null;
            }
            if (bound == null) {
                return this.myBound.accepts(wildcardType.getExtendsBound());
            }
            if (this.mySuper) {
                return wildcardType.isSuper() && this.myBound.accepts(bound);
            }
            return wildcardType.isExtends() && this.myBound.accepts(bound);
        }
        return false;
    }

    @Override
    @NotNull
    public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
        }
        if (this.myBound == null) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
            }
            return pointcutMatchDegree;
        }
        if (this.mySuper) {
            if (type instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)type;
                if (!wildcardType.isSuper()) {
                    PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
                    if (pointcutMatchDegree == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
                    }
                    return pointcutMatchDegree;
                }
                if (this.myBound.accepts(wildcardType.getBound())) {
                    PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
                    if (pointcutMatchDegree == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
                    }
                    return pointcutMatchDegree;
                }
            }
            if (this.myBound.accepts(type)) {
                PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
                if (pointcutMatchDegree == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
                }
                return pointcutMatchDegree;
            }
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = this.myBound.canBeAssignableFrom(type);
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/WildcardPattern", "canBeAssignableFrom"));
        }
        return pointcutMatchDegree;
    }
}

