/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopPointcut;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPointcutReferenceExpression
extends AopElementBase
implements PsiPointcutExpression {
    public PsiPointcutReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/PsiPointcutReferenceExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public AopReferenceExpression getReferenceExpression() {
        return (AopReferenceExpression)this.findChildByClass(AopReferenceExpression.class);
    }

    @Nullable
    public AopParameterList getParameterList() {
        return (AopParameterList)((Object)this.findChildByClass(AopParameterList.class));
    }

    public String toString() {
        return "PsiPointcutReferenceExpression";
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        PsiPointcutExpression pointcutExpression;
        AopPointcut pointcut;
        AopReferenceExpression expression = this.getReferenceExpression();
        if (expression != null && (pointcut = expression.resolvePointcut()) != null && (pointcutExpression = (PsiPointcutExpression)pointcut.getExpression().getValue()) != null) {
            PointcutMatchDegree pointcutMatchDegree = pointcutExpression.acceptsSubject(this.createContext(context, pointcutExpression), member);
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiPointcutReferenceExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiPointcutReferenceExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        PsiPointcutExpression pointcutExpression;
        AopPointcut pointcut;
        AopReferenceExpression expression = this.getReferenceExpression();
        if (expression != null && (pointcut = expression.resolvePointcut()) != null && (pointcutExpression = (PsiPointcutExpression)pointcut.getExpression().getValue()) != null) {
            Collection<AopPsiTypePattern> collection = pointcutExpression.getPatterns();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiPointcutReferenceExpression", "getPatterns"));
            }
            return collection;
        }
        List<AopPsiTypePattern> list = Arrays.asList(AopPsiTypePattern.FALSE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiPointcutReferenceExpression", "getPatterns"));
        }
        return list;
    }

    private PointcutContext createContext(PointcutContext context, PsiPointcutExpression pointcutExpression) {
        PsiMethod pointcutMethod = AopPointcutUtil.getHolder(pointcutExpression).getAopModel().getPointcutMethod();
        PointcutContext newContext = new PointcutContext(pointcutMethod);
        if (pointcutMethod != null) {
            PsiParameterList javaList = pointcutMethod.getParameterList();
            AopParameterList aopList = this.getParameterList();
            if (aopList != null) {
                PsiElement[] aopParameters = aopList.getParameters();
                PsiParameter[] psiParameters = javaList.getParameters();
                if (javaList.getParametersCount() == aopParameters.length) {
                    for (int i = 0; i < psiParameters.length; ++i) {
                        PsiElement aopParameter = aopParameters[i];
                        if (!(aopParameter instanceof AopReferenceHolder)) continue;
                        newContext.addParameter(psiParameters[i].getName(), context.resolve((AopReferenceHolder)aopParameter));
                    }
                }
            }
        }
        return newContext;
    }
}

