/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.WildcardPattern;
import com.intellij.lang.ASTNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopWildcardExpression
extends AopElementBase
implements AopTypeExpression {
    public AopWildcardExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopWildcardExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopWildcardExpression";
    }

    @Nullable
    public AopTypeExpression getBound() {
        return (AopTypeExpression)this.findChildByClass(AopTypeExpression.class);
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        AopTypeExpression bound = this.getBound();
        boolean isSuper = this.isSuper();
        if (bound == null) {
            List<AopPsiTypePattern> list = Arrays.asList(new WildcardPattern(null, isSuper));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopWildcardExpression", "getPatterns"));
            }
            return list;
        }
        List list = ContainerUtil.map2List(bound.getPatterns(), aopPsiTypePattern -> new WildcardPattern((AopPsiTypePattern)aopPsiTypePattern, isSuper));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopWildcardExpression", "getPatterns"));
        }
        return list;
    }

    @Override
    public String getTypePattern() {
        return "'_";
    }

    public boolean isExtends() {
        return this.findChildByType(AopElementTypes.AOP_EXTENDS) != null;
    }

    public boolean isSuper() {
        return this.findChildByType(AopElementTypes.AOP_SUPER) != null;
    }
}

