/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopArrayExpression;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopPrimitiveTypeExpression;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopReferenceHolder
extends AopElementBase
implements AopReferenceTarget {
    public AopReferenceHolder(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopReferenceHolder", "<init>"));
        }
        super(node);
    }

    @Nullable
    public AopTypeExpression getTypeExpression() {
        return (AopTypeExpression)this.findChildByClass(AopTypeExpression.class);
    }

    public String toString() {
        return "AopReferenceHolder";
    }

    @Override
    public PointcutMatchDegree accepts(@NotNull PsiType psiType) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "com/intellij/aop/psi/AopReferenceHolder", "accepts"));
        }
        AopTypeExpression typeExpression = this.getTypeExpression();
        return typeExpression != null ? AopPsiTypePattern.accepts(typeExpression, psiType) : PointcutMatchDegree.FALSE;
    }

    @Override
    @Nullable
    public String getTypePattern() {
        AopTypeExpression expression = this.getTypeExpression();
        if (expression == null) {
            return null;
        }
        return expression.getTypePattern();
    }

    public final Collection<AopPsiTypePattern> getPatterns() {
        AopTypeExpression expression = this.getTypeExpression();
        return expression == null ? Collections.emptyList() : expression.getPatterns();
    }

    @Override
    @Nullable
    public PsiClass findClass() {
        PsiElement psiElement;
        AopTypeExpression expression = this.getTypeExpression();
        if (expression instanceof AopReferenceExpression && (psiElement = ((AopReferenceExpression)expression).resolve()) instanceof PsiClass) {
            return (PsiClass)psiElement;
        }
        return null;
    }

    @Override
    public boolean isAssignableFrom(PsiType type) {
        AopTypeExpression expression = this.getTypeExpression();
        return expression != null && AopReferenceHolder.isAssignable(expression, type);
    }

    private static boolean isAssignable(@NotNull AopTypeExpression expression, PsiType type) {
        PsiPrimitiveType exprType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/aop/psi/AopReferenceHolder", "isAssignable"));
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            if (expression instanceof AopArrayExpression) {
                AopArrayExpression arrayExpression = (AopArrayExpression)expression;
                return arrayExpression.isVarargs() == arrayType instanceof PsiEllipsisType && AopReferenceHolder.isAssignable(arrayExpression.getTypeReference(), arrayType.getComponentType());
            }
            return false;
        }
        if (expression instanceof AopReferenceExpression) {
            PsiElement superClass = ((AopReferenceExpression)expression).resolve();
            if (!(superClass instanceof PsiClass)) {
                return false;
            }
            exprType = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory().createType((PsiClass)superClass);
        } else if (expression instanceof AopPrimitiveTypeExpression) {
            exprType = ((AopPrimitiveTypeExpression)expression).getPsiType();
        } else {
            return false;
        }
        if (exprType == null) {
            return false;
        }
        return exprType.isAssignableFrom(type);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String qname;
        PsiClass psiClass = this.findClass();
        if (psiClass != null && (qname = psiClass.getQualifiedName()) != null) {
            String string = qname;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceHolder", "getQualifiedName"));
            }
            return string;
        }
        String string = this.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopReferenceHolder", "getQualifiedName"));
        }
        return string;
    }

    @Override
    public PointcutMatchDegree canBeInstance(PsiClass psiClass, boolean allowPatterns) {
        return PsiTargetExpression.canBeInstanceOf(psiClass, allowPatterns, this.getTypeExpression());
    }
}

