/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopAnnotatedTypeExpression;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceQualifier;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.ConcatenationPattern;
import com.intellij.lang.ASTNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopMemberReferenceExpression
extends AopElementBase {
    public AopMemberReferenceExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopMemberReferenceExpression", "<init>"));
        }
        super(node);
    }

    @Nullable
    public AopReferenceExpression getReferenceExpression() {
        AopTypeExpression expression1;
        AopTypeExpression aopTypeExpression = this.getTypeExpression();
        if (aopTypeExpression instanceof AopReferenceExpression) {
            return (AopReferenceExpression)aopTypeExpression;
        }
        if (aopTypeExpression instanceof AopAnnotatedTypeExpression && (expression1 = ((AopAnnotatedTypeExpression)aopTypeExpression).getTypeExpression()) instanceof AopReferenceExpression) {
            return (AopReferenceExpression)expression1;
        }
        return null;
    }

    @Nullable
    public AopTypeExpression getTypeExpression() {
        return (AopTypeExpression)this.findChildByClass(AopTypeExpression.class);
    }

    public Collection<AopPsiTypePattern> getQualifierPatterns() {
        AopReferenceExpression expression = this.getReferenceExpression();
        if (expression == null) {
            return Arrays.asList(AopPsiTypePattern.TRUE);
        }
        AopReferenceQualifier qualifier = expression.getGeneralizedQualifier();
        if (qualifier == null) {
            return Arrays.asList(AopPsiTypePattern.TRUE);
        }
        AopTypeExpression typeExpression = this.getTypeExpression();
        return typeExpression instanceof AopAnnotatedTypeExpression ? ((AopAnnotatedTypeExpression)typeExpression).getQualifierPatterns() : qualifier.getPatterns();
    }

    public Collection<AopPsiTypePattern> getPatterns() {
        AopReferenceExpression expression = this.getReferenceExpression();
        Collection<AopPsiTypePattern> patterns = this.getQualifierPatterns();
        if (expression != null && expression.isDoubleDot()) {
            return ContainerUtil.map(patterns, aopPsiTypePattern -> new ConcatenationPattern((AopPsiTypePattern)aopPsiTypePattern, AopPsiTypePattern.TRUE, true));
        }
        return patterns;
    }

    public String toString() {
        return "AopMemberReferenceExpression";
    }
}

