/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.ArrayPattern;
import com.intellij.lang.ASTNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AopArrayExpression
extends AopElementBase
implements AopTypeExpression {
    public AopArrayExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopArrayExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopArrayExpression";
    }

    @NotNull
    public AopTypeExpression getTypeReference() {
        AopTypeExpression aopTypeExpression = (AopTypeExpression)this.findNotNullChildByClass(AopTypeExpression.class);
        if (aopTypeExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopArrayExpression", "getTypeReference"));
        }
        return aopTypeExpression;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        boolean varargs = this.isVarargs();
        List list = ContainerUtil.map2List(this.getTypeReference().getPatterns(), aopPsiTypePattern -> new ArrayPattern((AopPsiTypePattern)aopPsiTypePattern, varargs));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopArrayExpression", "getPatterns"));
        }
        return list;
    }

    @Override
    public String getTypePattern() {
        String pattern = this.getTypeReference().getTypePattern();
        return pattern == null ? null : (this.isVarargs() ? pattern + "..." : pattern + "[]");
    }

    public boolean isVarargs() {
        return this.findChildByType(AopElementTypes.AOP_VARARGS) != null;
    }
}

