/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopPointcut;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopArrayExpression;
import com.intellij.aop.psi.AopBinaryExpression;
import com.intellij.aop.psi.AopElementTypes;
import com.intellij.aop.psi.AopGenericTypeExpression;
import com.intellij.aop.psi.AopMemberReferenceExpression;
import com.intellij.aop.psi.AopNotExpression;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceQualifier;
import com.intellij.aop.psi.AopSubtypeExpression;
import com.intellij.aop.psi.AopTypeParameterList;
import com.intellij.aop.psi.PsiArgsExpression;
import com.intellij.aop.psi.PsiExecutionExpression;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.aop.psi.PsiPointcutReferenceExpression;
import com.intellij.aop.psi.PsiTargetExpression;
import com.intellij.aop.psi.PsiThisExpression;
import com.intellij.aop.psi.PsiWithinExpression;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.SimpleTextAttributes;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

public class AopAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        PsiPointcutExpression expression;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/aop/psi/AopAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/aop/psi/AopAnnotator", "annotate"));
        }
        if (AopPointcutUtil.getHolder(psiElement).getAopModel().getAdvisedElementsSearcher().shouldSuppressErrors()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (psiElement instanceof AopReferenceExpression && AopAnnotator.checkReference(psiElement, holder, parent)) {
            return;
        }
        if (psiElement instanceof AopParameterList && !(parent instanceof PsiExecutionExpression)) {
            AopAnnotator.checkEllipsisAllowance(psiElement, holder);
        }
        if (psiElement instanceof AopArrayExpression) {
            if (((AopArrayExpression)psiElement).isVarargs()) {
                PsiElement[] parameters;
                if (!(parent instanceof AopReferenceHolder) || parent.getParent() instanceof AopTypeParameterList || parent.getParent() instanceof AopParameterList && parent.getParent().getParent() instanceof PsiArgsExpression) {
                    holder.createErrorAnnotation(psiElement.getLastChild(), AopBundle.message("error.varargs.not.allowed.here", new Object[0]));
                    return;
                }
                if (parent.getParent() instanceof AopParameterList && parent != (parameters = ((AopParameterList)parent.getParent()).getParameters())[parameters.length - 1]) {
                    holder.createErrorAnnotation(psiElement.getLastChild(), AopBundle.message("error.varargs.not.last", new Object[0]));
                    return;
                }
            }
            if ((expression = (PsiPointcutExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPointcutExpression.class)) instanceof PsiThisExpression || expression instanceof PsiTargetExpression || expression instanceof PsiWithinExpression) {
                holder.createErrorAnnotation(psiElement.getLastChild(), AopBundle.message("error.arrays.not.allowed.here", new Object[0]));
            }
        }
        if (psiElement instanceof AopGenericTypeExpression && ((expression = (PsiPointcutExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiPointcutExpression.class)) instanceof PsiThisExpression || expression instanceof PsiTargetExpression || expression instanceof PsiWithinExpression)) {
            holder.createErrorAnnotation((PsiElement)((AopGenericTypeExpression)psiElement).getTypeParameterList(), AopBundle.message("error.generics.not.allowed.here", new Object[0]));
        }
        if ((psiElement instanceof AopSubtypeExpression || psiElement instanceof AopReferenceHolder && "*".equals(psiElement.getText())) && PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiArgsExpression.class) != null && PsiTreeUtil.getParentOfType((PsiElement)psiElement, AopTypeParameterList.class) != null && PsiTreeUtil.getParentOfType((PsiElement)psiElement, AopParameterList.class) != null) {
            holder.createErrorAnnotation(psiElement.getLastChild(), AopBundle.message("error.wildcards.not.allowed.here", new Object[0]));
        } else if (psiElement instanceof PsiPointcutReferenceExpression) {
            AopAnnotator.checkPointcutArgumentCount(psiElement, holder);
        } else if (!(psiElement.getContainingFile().getContext() instanceof XmlElement)) {
            AopAnnotator.checkAndOrNot(psiElement, holder);
        }
    }

    private static boolean checkReference(PsiElement psiElement, AnnotationHolder holder, PsiElement parent) {
        AopReferenceExpression referenceExpression = (AopReferenceExpression)psiElement;
        if (referenceExpression.getResolvability() != AopReferenceExpression.Resolvability.PLAIN) {
            return true;
        }
        TextRange range = referenceExpression.getRangeInElement().shiftRight(referenceExpression.getTextRange().getStartOffset());
        ResolveResult[] results = referenceExpression.multiResolve(false);
        if (results.length > 0) {
            for (ResolveResult result : results) {
                boolean error;
                PsiElement target = result.getElement();
                if (referenceExpression.isPointcutReference()) {
                    AopPointcutImpl pointcut;
                    if (!(target instanceof PsiMethod) || ((PsiMethod)target).getModifierList().findAnnotation("org.aspectj.lang.annotation.Pointcut") == null) {
                        holder.createErrorAnnotation(range, AopBundle.message("error.cannot.resolve.pointcut", referenceExpression.getReferenceName()));
                        return true;
                    }
                    PsiMethod pointcutMethod = AopPointcutUtil.getHolder(referenceExpression).getAopModel().getPointcutMethod();
                    if (pointcutMethod != null && (pointcut = JamAopModel.getPointcut(pointcutMethod)) != null && AopAnnotator.isRecursivePointcutRef(referenceExpression, pointcut, 3)) {
                        holder.createErrorAnnotation(range, AopBundle.message("error.recursive.pointcut.reference", referenceExpression));
                        return true;
                    }
                }
                if (!referenceExpression.isAnnotationReference()) continue;
                if (target instanceof PsiClass) {
                    error = !((PsiClass)target).isAnnotationType();
                } else if (target instanceof PsiParameter) {
                    PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)((PsiParameter)target).getType());
                    error = psiClass == null || !psiClass.isAnnotationType();
                } else {
                    boolean bl = error = target != null;
                }
                if (!error) continue;
                holder.createErrorAnnotation(range, AopBundle.message("error.anno.expected", new Object[0]));
                return true;
            }
            return true;
        }
        AopReferenceExpression qualifier = (AopReferenceExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.resolve() == null) {
            return true;
        }
        if (qualifier == null && !(referenceExpression.getParent() instanceof AopReferenceQualifier) && parent instanceof AopMemberReferenceExpression) {
            return true;
        }
        String message = referenceExpression.isPointcutReference() ? AopBundle.message("error.cannot.resolve.pointcut", referenceExpression.getReferenceName()) : AopBundle.message("error.cannot.resolve.symbol", referenceExpression.getReferenceName());
        holder.createErrorAnnotation(range, message).setEnforcedTextAttributes(SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes());
        return false;
    }

    private static boolean isRecursivePointcutRef(@NotNull AopReferenceExpression aopReferenceExpression, final @NotNull AopPointcut startPointcut, final int depth) {
        if (aopReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aopReferenceExpression", "com/intellij/aop/psi/AopAnnotator", "isRecursivePointcutRef"));
        }
        if (startPointcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPointcut", "com/intellij/aop/psi/AopAnnotator", "isRecursivePointcutRef"));
        }
        AopPointcut pointcut = aopReferenceExpression.resolvePointcut();
        if (pointcut == null) {
            return false;
        }
        if (pointcut.equals(startPointcut)) {
            return true;
        }
        if (depth == 0) {
            return false;
        }
        PsiPointcutExpression expression = (PsiPointcutExpression)pointcut.getExpression().getValue();
        final Ref result = Ref.create((Object)false);
        if (expression != null) {
            expression.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    PsiPointcutReferenceExpression pointcutReferenceExpression;
                    AopReferenceExpression referenceExpression;
                    if (((Boolean)result.get()).booleanValue()) {
                        return;
                    }
                    if (element instanceof PsiPointcutExpression) {
                        super.visitElement(element);
                    }
                    if (element instanceof PsiPointcutReferenceExpression && (referenceExpression = (pointcutReferenceExpression = (PsiPointcutReferenceExpression)element).getReferenceExpression()) != null && AopAnnotator.isRecursivePointcutRef(referenceExpression, startPointcut, depth - 1)) {
                        result.set((Object)true);
                    }
                }
            });
        }
        return (Boolean)result.get();
    }

    private static void checkEllipsisAllowance(PsiElement psiElement, AnnotationHolder holder) {
        AopParameterList list = (AopParameterList)psiElement;
        THashSet ellipsises = new THashSet();
        for (PsiElement parameter : list.getParameters()) {
            if (parameter.getNode().getElementType() != AopElementTypes.AOP_DOT_DOT) continue;
            ellipsises.add(parameter);
        }
        if (ellipsises.size() > 1) {
            for (PsiElement ellipsis : ellipsises) {
                holder.createErrorAnnotation(ellipsis, AopBundle.message("error.double.ellipsis.prohibited", new Object[0]));
            }
        }
    }

    private static void checkPointcutArgumentCount(PsiElement psiElement, AnnotationHolder holder) {
        PsiElement[] elements;
        int actual;
        AopParameterList parameterList;
        int expected;
        AopPointcut aopPointcut;
        PsiPointcutReferenceExpression expression = (PsiPointcutReferenceExpression)psiElement;
        AopReferenceExpression referenceExpression = expression.getReferenceExpression();
        if (referenceExpression != null && (aopPointcut = referenceExpression.resolvePointcut()) != null && (expected = aopPointcut.getParameterCount()) >= 0 && (parameterList = expression.getParameterList()) != null && (actual = (elements = parameterList.getParameters()).length) != expected) {
            holder.createErrorAnnotation((PsiElement)parameterList, AopBundle.message("error.invalid.number.of.arguments", expected, actual));
        }
    }

    private static void checkAndOrNot(PsiElement psiElement, AnnotationHolder holder) {
        AopNotExpression expression;
        PsiElement token;
        if (psiElement instanceof AopBinaryExpression) {
            String text;
            PsiElement token2 = ((AopBinaryExpression)psiElement).getOpToken();
            if (token2 != null && ("and".equals(text = token2.getText()) || "or".equals(text))) {
                holder.createErrorAnnotation(token2, AopBundle.message("error.0.or.1.expected", "&&", "||"));
            }
        } else if (psiElement instanceof AopNotExpression && "not".equals((token = (expression = (AopNotExpression)psiElement).getNotToken()).getText())) {
            holder.createErrorAnnotation(token, AopBundle.message("error.0.expected", "!"));
        }
    }
}

