/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopAnnotationHolder;
import com.intellij.aop.psi.AopBinaryExpression;
import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.lang.ASTNode;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopAnnotatedTypeExpression
extends AopElementBase
implements AopTypeExpression {
    public AopAnnotatedTypeExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopAnnotatedTypeExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopAnnotatedTypeExpression";
    }

    @Nullable
    public AopTypeExpression getTypeExpression() {
        return (AopTypeExpression)this.findChildByClass(AopTypeExpression.class);
    }

    @Nullable
    public AopAnnotationHolder getAnnotationHolder() {
        return (AopAnnotationHolder)((Object)this.findChildByClass(AopAnnotationHolder.class));
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        Collection<AopPsiTypePattern> collection = this.getPatterns(this.getTypeExpression());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopAnnotatedTypeExpression", "getPatterns"));
        }
        return collection;
    }

    @Override
    public String getTypePattern() {
        return "'_";
    }

    @NotNull
    public Collection<AopPsiTypePattern> getQualifierPatterns() {
        AopTypeExpression expression = this.getTypeExpression();
        if (!(expression instanceof AopReferenceExpression)) {
            List<AopPsiTypePattern> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopAnnotatedTypeExpression", "getQualifierPatterns"));
            }
            return list;
        }
        Collection<AopPsiTypePattern> collection = this.getPatterns(((AopReferenceExpression)expression).getGeneralizedQualifier());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopAnnotatedTypeExpression", "getQualifierPatterns"));
        }
        return collection;
    }

    private Collection<AopPsiTypePattern> getPatterns(AopTypeExpression typeExpression) {
        if (typeExpression == null) {
            return Collections.emptyList();
        }
        AopAnnotationHolder annotationHolder = this.getAnnotationHolder();
        if (annotationHolder == null) {
            return Collections.emptyList();
        }
        Collection<AopPsiTypePattern> typePatterns = typeExpression.getPatterns();
        Collection<AopPsiTypePattern> annoPatterns = annotationHolder.getPatterns();
        THashSet result = new THashSet();
        AopBinaryExpression.conjunctPatterns(typePatterns, annoPatterns, (Collection<AopPsiTypePattern>)result);
        return result;
    }
}

