/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopAnnoParameterReference;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodParameterConverter
extends JamConverter<PsiParameter> {
    public static final MethodParameterConverter INSTANCE = new MethodParameterConverter();

    private MethodParameterConverter() {
    }

    public PsiParameter fromString(@Nullable String name, JamStringAttributeElement<PsiParameter> context) {
        PsiAnnotation annotation = (PsiAnnotation)context.getParentAnnotationElement().getPsiElement();
        PsiMethod method = (PsiMethod)annotation.getParent().getParent();
        return name != null ? AopAdviceImpl.findParameter(method, name) : null;
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiParameter> context) {
        PsiLiteral expression = context.getPsiLiteral();
        if (expression == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/MethodParameterConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new AopAnnoParameterReference(expression)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/MethodParameterConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

