/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopAdviceMetas;
import com.intellij.aop.jam.AopAspectImpl;
import com.intellij.aop.jam.AopIntroductionImpl;
import com.intellij.aop.jam.AopPointcutImpl;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamAopModel {
    private final Module myModule;

    public JamAopModel(@Nullable Module module) {
        this.myModule = module;
    }

    public List<AopAspectImpl> getAspects() {
        if (this.myModule == null || DumbService.isDumb((Project)this.myModule.getProject())) {
            return Collections.emptyList();
        }
        return JamService.getJamService((Project)this.myModule.getProject()).getJamClassElements(AopAspectImpl.ASPECT_META, "org.aspectj.lang.annotation.Aspect", this.getModuleScope());
    }

    private GlobalSearchScope getModuleScope() {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
    }

    public List<AopPointcutImpl> getPointcuts() {
        if (this.myModule == null) {
            return Collections.emptyList();
        }
        return JamService.getJamService((Project)this.myModule.getProject()).getJamMethodElements(AopPointcutImpl.POINTCUT_METHOD_META, "org.aspectj.lang.annotation.Pointcut", this.getModuleScope());
    }

    @Nullable
    public static AopAdviceImpl getAdvice(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/aop/jam/JamAopModel", "getAdvice"));
        }
        return (AopAdviceImpl)JamService.getJamService((Project)method.getProject()).getJamElement((PsiElement)method, AopAdviceMetas.ADVICE_METHOD_METAS);
    }

    @Nullable
    public static AopPointcutImpl getPointcut(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/aop/jam/JamAopModel", "getPointcut"));
        }
        return (AopPointcutImpl)JamService.getJamService((Project)method.getProject()).getJamElement((PsiElement)method, new JamMemberMeta[]{AopPointcutImpl.POINTCUT_METHOD_META});
    }

    @Nullable
    public static AopIntroductionImpl getIntroduction(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/aop/jam/JamAopModel", "getIntroduction"));
        }
        return (AopIntroductionImpl)JamService.getJamService((Project)field.getProject()).getJamElement((PsiElement)field, new JamMemberMeta[]{AopAspectImpl.INTRODUCTION_FIELD_META});
    }
}

