/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopPointcut;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.IntroductionManipulator;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalAopModel {
    public static final Key<LocalAopModel> KEY = Key.create((String)"LocalAopModel");
    private final PsiMethod myMethod;
    private final PsiElement myHost;

    public LocalAopModel() {
        this(null, null);
    }

    public LocalAopModel(@Nullable PsiElement host, @Nullable PsiMethod pointcutMethod) {
        this.myHost = host;
        this.myMethod = pointcutMethod;
    }

    private JamAopModel getJamModel() {
        Module module = this.myHost != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myHost) : null;
        return new JamAopModel(module);
    }

    protected PsiElement getHost() {
        return this.myHost;
    }

    public List<? extends AopPointcut> getPointcuts() {
        return this.getJamModel().getPointcuts();
    }

    @Nullable
    public PsiMethod getPointcutMethod() {
        return this.myMethod;
    }

    @NotNull
    public List<PsiParameter> resolveParameters(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/aop/LocalAopModel", "resolveParameters"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)LocalAopModel.findParameter(name, this.getPointcutMethod()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/LocalAopModel", "resolveParameters"));
        }
        return list;
    }

    @Nullable
    protected static PsiParameter findParameter(String name, @Nullable PsiMethod method) {
        if (method == null) {
            return null;
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    public ArgNamesManipulator getArgNamesManipulator() {
        return null;
    }

    public static boolean isJoinPointParameter(PsiParameter parameter) {
        String typeText = parameter.getType().getCanonicalText();
        return "org.aspectj.lang.JoinPoint".equals(typeText) || "org.aspectj.lang.ProceedingJoinPoint".equals(typeText) || "org.aspectj.lang.JoinPoint.StaticPart".equals(typeText);
    }

    public abstract AopAdvisedElementsSearcher getAdvisedElementsSearcher();

    @Nullable
    public IntroductionManipulator getIntroductionManipulator() {
        return null;
    }
}

