/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitModuleStructure
extends AbstractQUnitModuleStructure {
    private final String myName;
    private final JSCallExpression myEnclosingCallExpression;
    private final JSObjectLiteralExpression myLifecycleObjectLiteral;

    public QUnitModuleStructure(@NotNull QUnitFileStructure fileStructure, @NotNull String name, @NotNull JSCallExpression enclosingCallExpression, @Nullable JSObjectLiteralExpression lifecycleObjectLiteral) {
        if (fileStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "<init>"));
        }
        if (enclosingCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingCallExpression", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "<init>"));
        }
        super(fileStructure, name);
        this.myName = name;
        this.myEnclosingCallExpression = enclosingCallExpression;
        this.myLifecycleObjectLiteral = lifecycleObjectLiteral;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "getName"));
        }
        return string;
    }

    @NotNull
    public JSCallExpression getEnclosingCallExpression() {
        JSCallExpression jSCallExpression = this.myEnclosingCallExpression;
        if (jSCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "getEnclosingCallExpression"));
        }
        return jSCallExpression;
    }

    @Nullable
    public JSProperty findLifecycleMethodByName(@NotNull String methodName) {
        JSProperty[] properties;
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "findLifecycleMethodByName"));
        }
        if (this.myLifecycleObjectLiteral == null) {
            return null;
        }
        for (JSProperty property : properties = JsPsiUtils.getProperties(this.myLifecycleObjectLiteral)) {
            String propertyName = JsPsiUtils.getPropertyName(property);
            if (!methodName.equals(propertyName)) continue;
            return property;
        }
        return null;
    }

    @Nullable
    public JSObjectLiteralExpression getLifecycleObjectLiteral() {
        return this.myLifecycleObjectLiteral;
    }

    @Override
    JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/qunit/QUnitModuleStructure", "findJstdRunElement"));
        }
        JstdRunElement jstdRunElement = super.findJstdRunElement(textRange);
        if (jstdRunElement == null && this.myEnclosingCallExpression.getTextRange().contains(textRange)) {
            return JstdRunElement.newTestCaseRunElement(this.getName());
        }
        return jstdRunElement;
    }
}

