/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QUnitFileStructureBuilder
extends AbstractTestFileStructureBuilder<QUnitFileStructure> {
    private static final QUnitFileStructureBuilder INSTANCE = new QUnitFileStructureBuilder();
    public static final String MODULE_NAME = "module";
    public static final String TEST_NAME = "test";
    public static final String ASYNC_TEST_NAME = "asyncTest";
    public static final String SUITE_NAME = "suite";

    @Override
    @NotNull
    public QUnitFileStructure buildTestFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder", "buildTestFileStructure"));
        }
        QUnitFileStructure qUnitFileStructure = new Builder(jsFile).build();
        if (qUnitFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder", "buildTestFileStructure"));
        }
        return qUnitFileStructure;
    }

    public static QUnitFileStructureBuilder getInstance() {
        return INSTANCE;
    }

    private static class Builder {
        private final QUnitFileStructure myFileStructure;
        @NotNull
        private AbstractQUnitModuleStructure myCurrentModuleStructure;

        private Builder(@NotNull JSFile jsFile) {
            if (jsFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder$Builder", "<init>"));
            }
            this.myFileStructure = new QUnitFileStructure(jsFile);
            this.myCurrentModuleStructure = this.myFileStructure.getDefaultModuleStructure();
        }

        public QUnitFileStructure build() {
            if (JsPsiUtils.mightContainGlobalCall((PsiFile)this.myFileStructure.getJsFile(), QUnitFileStructureBuilder.TEST_NAME, false)) {
                List<JSStatement> jsStatements = JsPsiUtils.listStatementsInExecutionOrder(this.myFileStructure.getJsFile());
                for (JSStatement jsStatement : jsStatements) {
                    this.update((JSElement)jsStatement);
                }
            }
            this.myFileStructure.postProcess();
            return this.myFileStructure;
        }

        private void update(JSElement jsElement) {
            JSCallExpression callExpression;
            JSExpressionStatement expressionStatement = (JSExpressionStatement)ObjectUtils.tryCast((Object)jsElement, JSExpressionStatement.class);
            if (expressionStatement != null && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class)) != null) {
                this.updateJsCallExpression(callExpression);
            }
        }

        private void updateJsCallExpression(@NotNull JSCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/javascript/testFramework/qunit/QUnitFileStructureBuilder$Builder", "updateJsCallExpression"));
            }
            JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
            JSArgumentList argumentList = callExpression.getArgumentList();
            if (methodExpression != null && methodExpression.getQualifier() == null && argumentList != null) {
                String name;
                String methodName = methodExpression.getReferenceName();
                JSExpression[] arguments = (JSExpression[])ObjectUtils.notNull((Object)argumentList.getArguments(), (Object)JSExpression.EMPTY_ARRAY);
                if (arguments.length >= 1 && (name = JsPsiUtils.extractStringValue(arguments[0])) != null) {
                    JSFunctionExpression body;
                    if (QUnitFileStructureBuilder.MODULE_NAME.equals(methodName) || QUnitFileStructureBuilder.SUITE_NAME.equals(methodName)) {
                        boolean ok = arguments.length == 1;
                        JSObjectLiteralExpression lifecycleObjectLiteral = null;
                        if (arguments.length == 2 && (lifecycleObjectLiteral = JsPsiUtils.extractObjectLiteralExpression(arguments[1])) != null) {
                            ok = true;
                        }
                        if (ok) {
                            QUnitModuleStructure moduleStructure = new QUnitModuleStructure(this.myFileStructure, name, callExpression, lifecycleObjectLiteral);
                            this.myFileStructure.addModuleStructure(moduleStructure);
                            this.myCurrentModuleStructure = moduleStructure;
                        }
                    } else if ((QUnitFileStructureBuilder.TEST_NAME.equals(methodName) || QUnitFileStructureBuilder.ASYNC_TEST_NAME.equals(methodName)) && arguments.length == 2 && (body = JsPsiUtils.extractFunctionExpression(arguments[1])) != null) {
                        QUnitTestMethodStructure testMethodStructure = new QUnitTestMethodStructure(this.myCurrentModuleStructure, name, callExpression, body);
                        this.myCurrentModuleStructure.addTestMethodStructure(testMethodStructure);
                    }
                }
            }
        }
    }
}

