/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.navigation;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestNavigationItem
implements NavigationItem {
    private final String myName;
    private final PsiElement myElement;

    public JsTestNavigationItem(@NotNull JsTestFqn fqn, @NotNull PsiElement element) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/javascript/testFramework/navigation/JsTestNavigationItem", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/navigation/JsTestNavigationItem", "<init>"));
        }
        this.myName = fqn.getPresentableName();
        this.myElement = element;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsTestNavigationItem.this.myName;
            }

            @Nullable
            public String getLocationString() {
                return JsTestNavigationItem.this.myElement.getContainingFile().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                Icon icon = JsTestNavigationItem.this.myElement.getContainingFile().getIcon(0);
                return icon != null ? icon : JsTestNavigationItem.this.myElement.getIcon(0);
            }
        };
    }

    public void navigate(boolean requestFocus) {
        VirtualFile file;
        Navigatable descriptor = null;
        if (this.myElement instanceof JSLiteralExpression && (file = this.myElement.getContainingFile().getVirtualFile()) != null) {
            descriptor = new OpenFileDescriptor(this.myElement.getProject(), file, this.myElement.getTextOffset() + 1);
        }
        if (descriptor == null) {
            descriptor = PsiNavigationSupport.getInstance().getDescriptor(this.myElement);
        }
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return PsiNavigationSupport.getInstance().canNavigate(this.myElement);
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    public static JsTestNavigationItem tryCreate(@NotNull String indexKey, @NotNull Project project) {
        PsiElement element;
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/javascript/testFramework/navigation/JsTestNavigationItem", "tryCreate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/testFramework/navigation/JsTestNavigationItem", "tryCreate"));
        }
        JsTestFqn fqn = JsTestFileByTestNameIndex.toFqn(indexKey);
        if (fqn == null) {
            return null;
        }
        List<VirtualFile> files = JsTestFileByTestNameIndex.findFilesByKey(indexKey, GlobalSearchScope.projectScope((Project)project));
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem(files);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof JSFile && (element = fqn.findNavigationElement((JSFile)psiFile)) != null) {
            return new JsTestNavigationItem(fqn, element);
        }
        return null;
    }
}

