/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.interfaces.mochaTdd;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.AbstractMochaTddElement;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddTest;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTddSuite
extends AbstractMochaTddElement {
    private final JSCallExpression myEnclosingCallExpression;
    private List<AbstractMochaTddElement> myChildren;

    public MochaTddSuite(@NotNull String name, @NotNull JSCallExpression enclosingCallExpression, @Nullable MochaTddSuite parent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "<init>"));
        }
        if (enclosingCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingCallExpression", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "<init>"));
        }
        super(name, parent);
        this.myEnclosingCallExpression = enclosingCallExpression;
    }

    @NotNull
    public JSCallExpression getEnclosingCallExpression() {
        JSCallExpression jSCallExpression = this.myEnclosingCallExpression;
        if (jSCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "getEnclosingCallExpression"));
        }
        return jSCallExpression;
    }

    public void setChildren(@NotNull List<AbstractMochaTddElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "setChildren"));
        }
        this.myChildren = ImmutableList.copyOf(elements);
    }

    @NotNull
    public List<AbstractMochaTddElement> getChildren() {
        List<AbstractMochaTddElement> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "getChildren"));
        }
        return list;
    }

    @Nullable
    public MochaTddSuite findSuiteByName(@NotNull String suiteName) {
        if (suiteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteName", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "findSuiteByName"));
        }
        for (AbstractMochaTddElement child : this.myChildren) {
            if (!(child instanceof MochaTddSuite) || !child.getName().equals(suiteName)) continue;
            return (MochaTddSuite)child;
        }
        return null;
    }

    @Nullable
    public MochaTddTest findTestByName(@NotNull String testName) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "findTestByName"));
        }
        for (AbstractMochaTddElement child : this.myChildren) {
            if (!(child instanceof MochaTddTest) || !child.getName().equals(testName)) continue;
            return (MochaTddTest)child;
        }
        return null;
    }

    @Nullable
    public AbstractMochaTddElement findDeepestElementContainingRange(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/javascript/testFramework/interfaces/mochaTdd/MochaTddSuite", "findDeepestElementContainingRange"));
        }
        if (!this.myEnclosingCallExpression.getTextRange().contains(range)) {
            return null;
        }
        for (AbstractMochaTddElement child : this.myChildren) {
            if (child instanceof MochaTddSuite) {
                AbstractMochaTddElement result = ((MochaTddSuite)child).findDeepestElementContainingRange(range);
                if (result == null) continue;
                return result;
            }
            MochaTddTest test = (MochaTddTest)child;
            if (!test.getCallExpression().getTextRange().contains(range)) continue;
            return test;
        }
        return this;
    }
}

