/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

public class MavenProjectOpenProcessor
extends ProjectOpenProcessorBase<MavenProjectBuilder> {
    public MavenProjectOpenProcessor(@NotNull MavenProjectBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/idea/maven/wizards/MavenProjectOpenProcessor", "<init>"));
        }
        super((ProjectImportBuilder)builder);
    }

    @Nullable
    public String[] getSupportedExtensions() {
        return MavenConstants.POM_NAMES;
    }

    public boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        ((MavenProjectBuilder)this.getBuilder()).setFiles(Collections.singletonList(file));
        if (!((MavenProjectBuilder)this.getBuilder()).setSelectedProfiles(MavenExplicitProfiles.NONE)) {
            return false;
        }
        List<MavenProject> projects = ((MavenProjectBuilder)this.getBuilder()).getList();
        if (projects.size() != 1) {
            return false;
        }
        ((MavenProjectBuilder)this.getBuilder()).setList(projects);
        wizardContext.setProjectName(((MavenProjectBuilder)this.getBuilder()).getSuggestedProjectName());
        return true;
    }
}

