/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public class MavenProjectsProcessorReadingTask
implements MavenProjectsProcessorTask {
    private final boolean myForce;
    private final MavenProjectsTree myTree;
    private final MavenGeneralSettings mySettings;
    private final List<VirtualFile> myFilesToUpdate;
    private final List<VirtualFile> myFilesToDelete;
    @Nullable
    private final Runnable myOnCompletion;

    public MavenProjectsProcessorReadingTask(boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, @Nullable Runnable onCompletion) {
        this(null, null, force, tree, settings, onCompletion);
    }

    public MavenProjectsProcessorReadingTask(List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, boolean force, MavenProjectsTree tree, MavenGeneralSettings settings, @Nullable Runnable onCompletion) {
        this.myForce = force;
        this.myTree = tree;
        this.mySettings = settings;
        this.myFilesToUpdate = filesToUpdate;
        this.myFilesToDelete = filesToDelete;
        this.myOnCompletion = onCompletion;
    }

    @Override
    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (this.myFilesToUpdate == null) {
            this.myTree.updateAll(this.myForce, this.mySettings, indicator);
        } else {
            this.myTree.delete(this.myFilesToDelete, this.mySettings, indicator);
            this.myTree.update(this.myFilesToUpdate, this.myForce, this.mySettings, indicator);
        }
        if (this.myOnCompletion != null) {
            this.myOnCompletion.run();
        }
    }
}

