/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.CommonBundle;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenDefaultModelsProvider;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenModificationTracker;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManagerState;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.project.MavenProjectsProcessor;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorArtifactsDownloadingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorEmptyTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorFoldersResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorPluginsResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorResolvingTask;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenResourceCompilerConfigurationGenerator;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;

@State(name="MavenProjectsManager")
public class MavenProjectsManager
extends MavenSimpleProjectComponent
implements PersistentStateComponent<MavenProjectsManagerState>,
SettingsSavingComponent {
    private static final int IMPORT_DELAY = 1000;
    private static final String NON_MANAGED_POM_NOTIFICATION_GROUP_ID = "Maven: non-managed pom.xml";
    private static final NotificationGroup NON_MANAGED_POM_NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"Maven: non-managed pom.xml");
    private final ReentrantLock initLock = new ReentrantLock();
    private final AtomicBoolean isInitialized = new AtomicBoolean();
    private MavenProjectsManagerState myState = new MavenProjectsManagerState();
    private final Alarm myInitializationAlarm;
    private final MavenEmbeddersManager myEmbeddersManager;
    private MavenProjectsTree myProjectsTree;
    private MavenProjectsManagerWatcher myWatcher;
    private MavenProjectsProcessor myReadingProcessor;
    private MavenProjectsProcessor myResolvingProcessor;
    private MavenProjectsProcessor myPluginsResolvingProcessor;
    private MavenProjectsProcessor myFoldersResolvingProcessor;
    private MavenProjectsProcessor myArtifactsDownloadingProcessor;
    private MavenProjectsProcessor myPostProcessor;
    private MavenMergingUpdateQueue myImportingQueue;
    private final Object myImportingDataLock = new Object();
    private final Map<MavenProject, MavenProjectChanges> myProjectsToImport = new LinkedHashMap<MavenProject, MavenProjectChanges>();
    private final Set<MavenProject> myProjectsToResolve = new LinkedHashSet<MavenProject>();
    private boolean myImportModuleGroupsRequired = false;
    private final EventDispatcher<MavenProjectsTree.Listener> myProjectsTreeDispatcher = EventDispatcher.create(MavenProjectsTree.Listener.class);
    private final List<Listener> myManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private ModificationTracker myModificationTracker;
    private MavenWorkspaceSettings myWorkspaceSettings;
    private MavenMergingUpdateQueue mySaveQueue;
    private static final int SAVE_DELAY = 1000;

    public static MavenProjectsManager getInstance(Project p) {
        return (MavenProjectsManager)((Object)p.getComponent(MavenProjectsManager.class));
    }

    public MavenProjectsManager(Project project) {
        super(project);
        this.myEmbeddersManager = new MavenEmbeddersManager(project);
        this.myModificationTracker = new MavenModificationTracker(this);
        this.myInitializationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        this.mySaveQueue = new MavenMergingUpdateQueue("Maven save queue", 1000, !this.isUnitTestMode(), null);
    }

    public MavenProjectsManagerState getState() {
        if (this.isInitialized()) {
            this.applyTreeToState();
        }
        return this.myState;
    }

    public void loadState(MavenProjectsManagerState state) {
        this.myState = state;
        if (this.isInitialized()) {
            this.applyStateToTree();
            this.scheduleUpdateAllProjects(false);
        }
    }

    public void disposeComponent() {
        super.disposeComponent();
        Disposer.dispose((Disposable)this.mySaveQueue);
    }

    public ModificationTracker getModificationTracker() {
        return this.myModificationTracker;
    }

    public MavenGeneralSettings getGeneralSettings() {
        return this.getWorkspaceSettings().generalSettings;
    }

    public MavenImportingSettings getImportingSettings() {
        return this.getWorkspaceSettings().importingSettings;
    }

    private MavenWorkspaceSettings getWorkspaceSettings() {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings();
        }
        return this.myWorkspaceSettings;
    }

    public File getLocalRepository() {
        return this.getGeneralSettings().getEffectiveLocalRepository();
    }

    public void initComponent() {
        if (!this.isNormalProject()) {
            return;
        }
        StartupManagerEx startupManager = StartupManagerEx.getInstanceEx((Project)this.myProject);
        startupManager.registerStartupActivity(() -> {
            boolean wasMavenized;
            boolean bl = wasMavenized = !this.myState.originalFiles.isEmpty();
            if (!wasMavenized) {
                return;
            }
            this.initMavenized();
        });
        startupManager.registerPostStartupActivity(() -> {
            if (!this.isMavenizedProject()) {
                this.showNotificationOrphanMavenProject(this.myProject);
            }
            CompilerManager.getInstance((Project)this.myProject).addBeforeTask(new CompileTask(){

                public boolean execute(CompileContext context) {
                    AccessToken token = ReadAction.start();
                    try {
                        new MavenResourceCompilerConfigurationGenerator(MavenProjectsManager.this.myProject, MavenProjectsManager.this.myProjectsTree).generateBuildConfiguration(context.isRebuild());
                    }
                    finally {
                        token.finish();
                    }
                    return true;
                }
            });
        });
    }

    private void showNotificationOrphanMavenProject(Project project) {
        NotificationSettings notificationSettings = NotificationsConfigurationImpl.getSettings((String)NON_MANAGED_POM_NOTIFICATION_GROUP_ID);
        if (!notificationSettings.isShouldLog() && notificationSettings.getDisplayType().equals((Object)NotificationDisplayType.NONE)) {
            return;
        }
        File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)project.getBaseDir());
        File pomXml = new File(baseDir, "pom.xml");
        if (pomXml.exists()) {
            final VirtualFile file = VfsUtil.findFileByIoFile((File)pomXml, (boolean)true);
            if (file == null) {
                return;
            }
            this.showBalloon(ProjectBundle.message("maven.orphan.notification.title", new Object[0]), ProjectBundle.message("maven.orphan.notification.msg", file.getPresentableUrl()), NON_MANAGED_POM_NOTIFICATION_GROUP, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/idea/maven/project/MavenProjectsManager$2", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/MavenProjectsManager$2", "hyperlinkActivated"));
                    }
                    if ("#add".equals(e.getDescription())) {
                        MavenProjectsManager.this.addManagedFilesOrUnignore(ContainerUtil.list((Object[])new VirtualFile[]{file}));
                        notification.expire();
                    } else if ("#disable".equals(e.getDescription())) {
                        int result = Messages.showYesNoDialog((Project)MavenProjectsManager.this.myProject, (String)"Notification will be disabled for all projects.\n\nSettings | Appearance & Behavior | Notifications | Maven: non-managed pom.xml\ncan be used to configure the notification.", (String)"Non-Managed Maven Project Detection", (String)"Disable Notification", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                        if (result == 0) {
                            NotificationsConfigurationImpl.getInstanceImpl().changeSettings(MavenProjectsManager.NON_MANAGED_POM_NOTIFICATION_GROUP_ID, NotificationDisplayType.NONE, false, false);
                            notification.expire();
                        } else {
                            notification.hideBalloon();
                        }
                    }
                }
            });
        }
    }

    public void showBalloon(@NotNull String title, @NotNull String message, @NotNull NotificationGroup group, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/idea/maven/project/MavenProjectsManager", "showBalloon"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/maven/project/MavenProjectsManager", "showBalloon"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/idea/maven/project/MavenProjectsManager", "showBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/project/MavenProjectsManager", "showBalloon"));
        }
        group.createNotification(title, message, type, listener).notify(this.myProject);
    }

    private void initMavenized() {
        this.doInit(false);
    }

    private void initNew(List<VirtualFile> files, MavenExplicitProfiles explicitProfiles) {
        this.myState.originalFiles = MavenUtil.collectPaths(files);
        this.getWorkspaceSettings().setEnabledProfiles(explicitProfiles.getEnabledProfiles());
        this.getWorkspaceSettings().setDisabledProfiles(explicitProfiles.getDisabledProfiles());
        this.doInit(true);
    }

    public void initForTests() {
        this.doInit(false);
    }

    private void doInit(boolean isNew) {
        this.initLock.lock();
        try {
            if (this.isInitialized.getAndSet(true)) {
                return;
            }
            this.initProjectsTree(!isNew);
            this.initWorkers();
            this.listenForSettingsChanges();
            this.listenForProjectsTreeChanges();
            MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
                if (!this.isUnitTestMode()) {
                    this.fireActivated();
                    this.listenForExternalChanges();
                }
                this.scheduleUpdateAllProjects(isNew);
            }));
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void initProjectsTree(boolean tryToLoadExisting) {
        if (tryToLoadExisting) {
            File file = this.getProjectsTreeFile();
            try {
                if (file.exists()) {
                    this.myProjectsTree = MavenProjectsTree.read(this.myProject, file);
                }
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        if (this.myProjectsTree == null) {
            this.myProjectsTree = new MavenProjectsTree(this.myProject);
        }
        this.applyStateToTree();
        this.myProjectsTree.addListener((MavenProjectsTree.Listener)this.myProjectsTreeDispatcher.getMulticaster());
    }

    private void applyTreeToState() {
        this.myState.originalFiles = this.myProjectsTree.getManagedFilesPaths();
        this.myState.ignoredFiles = new THashSet(this.myProjectsTree.getIgnoredFilesPaths());
        this.myState.ignoredPathMasks = this.myProjectsTree.getIgnoredFilesPatterns();
    }

    private void applyStateToTree() {
        MavenWorkspaceSettings settings = this.getWorkspaceSettings();
        MavenExplicitProfiles explicitProfiles = new MavenExplicitProfiles(settings.enabledProfiles, settings.disabledProfiles);
        this.myProjectsTree.resetManagedFilesPathsAndProfiles(this.myState.originalFiles, explicitProfiles);
        this.myProjectsTree.setIgnoredFilesPaths(new ArrayList<String>(this.myState.ignoredFiles));
        this.myProjectsTree.setIgnoredFilesPatterns(this.myState.ignoredPathMasks);
    }

    public void save() {
        if (this.myProjectsTree != null) {
            this.mySaveQueue.queue(new Update((Object)this){

                public void run() {
                    try {
                        MavenProjectsManager.this.myProjectsTree.save(MavenProjectsManager.this.getProjectsTreeFile());
                    }
                    catch (IOException e) {
                        MavenLog.LOG.info((Throwable)e);
                    }
                }
            });
        }
    }

    private File getProjectsTreeFile() {
        return new File(MavenProjectsManager.getProjectsTreesDir(), this.myProject.getLocationHash() + "/tree.dat");
    }

    private static File getProjectsTreesDir() {
        return MavenUtil.getPluginSystemDir("Projects");
    }

    private void initWorkers() {
        this.myReadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.reading", new Object[0]), false, this.myEmbeddersManager);
        this.myResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.resolving", new Object[0]), true, this.myEmbeddersManager);
        this.myPluginsResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading.plugins", new Object[0]), true, this.myEmbeddersManager);
        this.myFoldersResolvingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.updating.folders", new Object[0]), true, this.myEmbeddersManager);
        this.myArtifactsDownloadingProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.downloading", new Object[0]), true, this.myEmbeddersManager);
        this.myPostProcessor = new MavenProjectsProcessor(this.myProject, ProjectBundle.message("maven.post.processing", new Object[0]), true, this.myEmbeddersManager);
        this.myWatcher = new MavenProjectsManagerWatcher(this.myProject, this, this.myProjectsTree, this.getGeneralSettings(), this.myReadingProcessor, this.myEmbeddersManager);
        this.myImportingQueue = new MavenMergingUpdateQueue(this.getComponentName() + ": Importing queue", 1000, !this.isUnitTestMode(), (Disposable)this.myProject);
        this.myImportingQueue.setPassThrough(false);
        this.myImportingQueue.makeUserAware(this.myProject);
        this.myImportingQueue.makeDumbAware(this.myProject);
        this.myImportingQueue.makeModalAware(this.myProject);
    }

    private void listenForSettingsChanges() {
        this.getImportingSettings().addListener(new MavenImportingSettings.Listener(){

            @Override
            public void autoImportChanged() {
                if (MavenProjectsManager.this.myProject.isDisposed()) {
                    return;
                }
                if (MavenProjectsManager.this.getImportingSettings().isImportAutomatically()) {
                    MavenProjectsManager.this.scheduleImportAndResolve();
                }
            }

            @Override
            public void createModuleGroupsChanged() {
                MavenProjectsManager.this.scheduleImportSettings(true);
            }

            @Override
            public void createModuleForAggregatorsChanged() {
                MavenProjectsManager.this.scheduleImportSettings();
            }
        });
    }

    private void listenForProjectsTreeChanges() {
        this.myProjectsTree.addListener(new MavenProjectsTree.ListenerAdapter(){

            @Override
            public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
                if (!fromImport) {
                    MavenProjectsManager.this.scheduleImport();
                }
            }

            @Override
            public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
                MavenProject project;
                MavenProjectsManager.this.myEmbeddersManager.clearCaches();
                MavenProjectsManager.this.unscheduleAllTasks(deleted);
                List<MavenProject> updatedProjects = MavenUtil.collectFirsts(updated);
                ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(updated);
                for (MavenProject eachDependent : MavenProjectsManager.this.myProjectsTree.getDependentProjects(updatedProjects)) {
                    toImport.add(Pair.create((Object)eachDependent, (Object)MavenProjectChanges.DEPENDENCIES));
                }
                THashSet toResolve = new THashSet(updatedProjects);
                toResolve.addAll(MavenProjectsManager.this.myProjectsTree.getDependentProjects(ContainerUtil.concat(updatedProjects, deleted)));
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    if (!each.hasReadingProblems()) continue;
                    it.remove();
                }
                if (this.haveChanges(toImport) || !deleted.isEmpty()) {
                    MavenProjectsManager.this.scheduleForNextImport(toImport);
                }
                if (!deleted.isEmpty() && !MavenProjectsManager.this.hasScheduledProjects() && (project = (MavenProject)ObjectUtils.chooseNotNull((Object)ContainerUtil.getFirstItem((Collection)toResolve), (Object)ContainerUtil.getFirstItem(MavenProjectsManager.this.getNonIgnoredProjects()))) != null) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)MavenProjectChanges.ALL));
                    MavenProjectsManager.this.scheduleForNextResolve(ContainerUtil.list((Object[])new MavenProject[]{project}));
                }
                MavenProjectsManager.this.scheduleForNextResolve((Collection)toResolve);
                MavenProjectsManager.this.fireProjectScheduled();
            }

            private boolean haveChanges(List<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
                for (MavenProjectChanges each : MavenUtil.collectSeconds(projectsWithChanges)) {
                    if (!each.hasChanges()) continue;
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                if (nativeMavenProject != null) {
                    if (this.shouldScheduleProject(projectWithChanges)) {
                        MavenImportingSettings importingSettings;
                        MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                        AccessToken token = ReadAction.start();
                        try {
                            if (MavenProjectsManager.this.myProject.isDisposed()) {
                                return;
                            }
                            importingSettings = MavenProjectsManager.this.getImportingSettings();
                        }
                        finally {
                            token.finish();
                        }
                        MavenProjectsManager.this.scheduleArtifactsDownloading(Collections.singleton(projectWithChanges.first), null, importingSettings.isDownloadSourcesAutomatically(), importingSettings.isDownloadDocsAutomatically(), null);
                    }
                    if (!((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProject)projectWithChanges.first).hasUnresolvedPlugins()) {
                        MavenProjectsManager.this.schedulePluginsResolve((MavenProject)projectWithChanges.first, nativeMavenProject);
                    }
                }
            }

            @Override
            public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                if (this.shouldScheduleProject(projectWithChanges)) {
                    MavenProjectsManager.this.scheduleForNextImport((Pair<MavenProject, MavenProjectChanges>)projectWithChanges);
                }
            }

            private boolean shouldScheduleProject(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                return !((MavenProject)projectWithChanges.first).hasReadingProblems() && ((MavenProjectChanges)projectWithChanges.second).hasChanges();
            }
        });
    }

    public void listenForExternalChanges() {
        this.myWatcher.start();
    }

    public void projectClosed() {
        this.initLock.lock();
        try {
            if (!this.isInitialized.getAndSet(false)) {
                return;
            }
            Disposer.dispose((Disposable)this.myImportingQueue);
            this.myWatcher.stop();
            this.myReadingProcessor.stop();
            this.myResolvingProcessor.stop();
            this.myPluginsResolvingProcessor.stop();
            this.myFoldersResolvingProcessor.stop();
            this.myArtifactsDownloadingProcessor.stop();
            this.myPostProcessor.stop();
            this.mySaveQueue.flush();
            if (this.isUnitTestMode()) {
                FileUtil.delete((File)MavenProjectsManager.getProjectsTreesDir());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    public MavenEmbeddersManager getEmbeddersManager() {
        return this.myEmbeddersManager;
    }

    private boolean isInitialized() {
        return !this.initLock.isLocked() && this.isInitialized.get();
    }

    public boolean isMavenizedProject() {
        return this.isInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMavenizedModule(Module m) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            boolean bl = !m.isDisposed() && "true".equals(m.getOptionValue(MavenProjectsManager.getMavenizedModuleOptionName()));
            return bl;
        }
        finally {
            accessToken.finish();
        }
    }

    public void setMavenizedModules(Collection<Module> modules, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Module m : modules) {
            if (m.isDisposed()) continue;
            if (mavenized) {
                m.setOption(MavenProjectsManager.getMavenizedModuleOptionName(), "true");
                m.clearOption("external.system.id");
                m.clearOption("external.linked.project.path");
                m.clearOption("external.root.project.path");
                m.clearOption("external.system.module.group");
                m.clearOption("external.system.module.version");
                continue;
            }
            m.clearOption(MavenProjectsManager.getMavenizedModuleOptionName());
        }
    }

    private static String getMavenizedModuleOptionName() {
        return "org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule";
    }

    public void resetManagedFilesAndProfilesInTests(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        this.myWatcher.resetManagedFilesAndProfilesInTests(files, profiles);
    }

    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        if (!this.isInitialized()) {
            this.initNew(files, profiles);
        } else {
            this.myWatcher.addManagedFilesWithProfiles(files, profiles);
        }
        MavenUtil.invokeLater(this.myProject, () -> {
            if (this.myProject == null || !this.myProject.isDefault() && !this.myProject.isDisposed()) {
                for (Notification notification : EventLog.getLogModel((Project)this.myProject).getNotifications()) {
                    if (!NON_MANAGED_POM_NOTIFICATION_GROUP_ID.equals(notification.getGroupId())) continue;
                    for (VirtualFile file : files) {
                        if (!StringUtil.startsWith((CharSequence)notification.getContent(), (CharSequence)file.getPresentableUrl())) continue;
                        notification.expire();
                    }
                }
            }
        });
    }

    public void addManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/maven/project/MavenProjectsManager", "addManagedFiles"));
        }
        this.addManagedFilesWithProfiles(files, MavenExplicitProfiles.NONE);
    }

    public void addManagedFilesOrUnignore(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/maven/project/MavenProjectsManager", "addManagedFilesOrUnignore"));
        }
        this.removeIgnoredFilesPaths(MavenUtil.collectPaths(files));
        this.addManagedFiles(files);
    }

    public void removeManagedFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/maven/project/MavenProjectsManager", "removeManagedFiles"));
        }
        this.myWatcher.removeManagedFiles(files);
    }

    public boolean isManagedFile(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/project/MavenProjectsManager", "isManagedFile"));
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isManagedFile(f);
    }

    @NotNull
    public MavenExplicitProfiles getExplicitProfiles() {
        if (!this.isInitialized()) {
            MavenExplicitProfiles mavenExplicitProfiles = MavenExplicitProfiles.NONE;
            if (mavenExplicitProfiles == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getExplicitProfiles"));
            }
            return mavenExplicitProfiles;
        }
        MavenExplicitProfiles mavenExplicitProfiles = this.myProjectsTree.getExplicitProfiles();
        if (mavenExplicitProfiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getExplicitProfiles"));
        }
        return mavenExplicitProfiles;
    }

    public void setExplicitProfiles(@NotNull MavenExplicitProfiles profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "org/jetbrains/idea/maven/project/MavenProjectsManager", "setExplicitProfiles"));
        }
        this.myWatcher.setExplicitProfiles(profiles);
    }

    @NotNull
    public Collection<String> getAvailableProfiles() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getAvailableProfiles"));
            }
            return list;
        }
        Collection<String> collection = this.myProjectsTree.getAvailableProfiles();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getAvailableProfiles"));
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        if (!this.isInitialized()) {
            List<Pair<String, MavenProfileKind>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProfilesWithStates"));
            }
            return list;
        }
        Collection<Pair<String, MavenProfileKind>> collection = this.myProjectsTree.getProfilesWithStates();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProfilesWithStates"));
        }
        return collection;
    }

    public boolean hasProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.hasProjects();
    }

    @NotNull
    public List<MavenProject> getProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProjects"));
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getProjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProjects"));
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getRootProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getRootProjects"));
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getRootProjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getRootProjects"));
        }
        return list;
    }

    @NotNull
    public List<MavenProject> getNonIgnoredProjects() {
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getNonIgnoredProjects"));
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getNonIgnoredProjects();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getNonIgnoredProjects"));
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getProjectsFiles() {
        if (!this.isInitialized()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProjectsFiles"));
            }
            return list;
        }
        List<VirtualFile> list = this.myProjectsTree.getProjectsFiles();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getProjectsFiles"));
        }
        return list;
    }

    @Nullable
    public MavenProject findProject(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findProject"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(f);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findProject"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(id);
    }

    @Nullable
    public MavenProject findProject(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findProject"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findProject(artifact);
    }

    @Nullable
    public MavenProject findProject(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findProject"));
        }
        VirtualFile f = MavenProjectsManager.findPomFile(module, new MavenModelsProvider(){

            @Override
            public Module[] getModules() {
                throw new UnsupportedOperationException();
            }

            @Override
            public VirtualFile[] getContentRoots(Module module) {
                return ModuleRootManager.getInstance((Module)module).getContentRoots();
            }
        });
        return f == null ? null : this.findProject(f);
    }

    @Nullable
    public Module findModule(@NotNull MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findModule"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(project.getFile());
    }

    @NotNull
    public Collection<MavenProject> findInheritors(@Nullable MavenProject parent) {
        if (parent == null || !this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findInheritors"));
            }
            return list;
        }
        Collection<MavenProject> collection = this.myProjectsTree.findInheritors(parent);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findInheritors"));
        }
        return collection;
    }

    @Nullable
    public MavenProject findContainingProject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findContainingProject"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        Module module = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(file);
        return module == null ? null : this.findProject(module);
    }

    @Nullable
    private static VirtualFile findPomFile(@NotNull Module module, @NotNull MavenModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findPomFile"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findPomFile"));
        }
        for (VirtualFile root : modelsProvider.getContentRoots(module)) {
            for (VirtualFile child : root.getChildren()) {
                if (!MavenUtil.isPomFileName(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Nullable
    public MavenProject findAggregator(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findAggregator"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findAggregator(mavenProject);
    }

    @Nullable
    public MavenProject findRootProject(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsManager", "findRootProject"));
        }
        if (!this.isInitialized()) {
            return null;
        }
        return this.myProjectsTree.findRootProject(mavenProject);
    }

    @NotNull
    public List<MavenProject> getModules(@NotNull MavenProject aggregator) {
        if (aggregator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aggregator", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getModules"));
        }
        if (!this.isInitialized()) {
            List<MavenProject> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getModules"));
            }
            return list;
        }
        List<MavenProject> list = this.myProjectsTree.getModules(aggregator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getModules"));
        }
        return list;
    }

    @NotNull
    public List<String> getIgnoredFilesPaths() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getIgnoredFilesPaths"));
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPaths();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getIgnoredFilesPaths"));
        }
        return list;
    }

    public void setIgnoredFilesPaths(@NotNull List<String> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/maven/project/MavenProjectsManager", "setIgnoredFilesPaths"));
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPaths(paths);
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.removeIgnoredFilesPaths(paths);
    }

    public boolean getIgnoredState(@NotNull MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getIgnoredState"));
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.getIgnoredState(project);
    }

    public void setIgnoredState(@NotNull List<MavenProject> projects, boolean ignored) {
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "org/jetbrains/idea/maven/project/MavenProjectsManager", "setIgnoredState"));
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredState(projects, ignored);
    }

    @NotNull
    public List<String> getIgnoredFilesPatterns() {
        if (!this.isInitialized()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getIgnoredFilesPatterns"));
            }
            return list;
        }
        List<String> list = this.myProjectsTree.getIgnoredFilesPatterns();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsManager", "getIgnoredFilesPatterns"));
        }
        return list;
    }

    public void setIgnoredFilesPatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "org/jetbrains/idea/maven/project/MavenProjectsManager", "setIgnoredFilesPatterns"));
        }
        if (!this.isInitialized()) {
            return;
        }
        this.myProjectsTree.setIgnoredFilesPatterns(patterns);
    }

    public boolean isIgnored(@NotNull MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsManager", "isIgnored"));
        }
        if (!this.isInitialized()) {
            return false;
        }
        return this.myProjectsTree.isIgnored(project);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        THashSet result = new THashSet();
        for (MavenProject each : this.getProjects()) {
            for (MavenRemoteRepository eachRepository : each.getRemoteRepositories()) {
                result.add(eachRepository);
            }
        }
        return result;
    }

    public MavenProjectsTree getProjectsTreeForTests() {
        return this.myProjectsTree;
    }

    private void scheduleUpdateAllProjects(boolean forceImportAndResolve) {
        this.doScheduleUpdateProjects(null, false, forceImportAndResolve);
    }

    public AsyncPromise<Void> forceUpdateProjects(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "org/jetbrains/idea/maven/project/MavenProjectsManager", "forceUpdateProjects"));
        }
        return this.doScheduleUpdateProjects(projects, true, true);
    }

    public void forceUpdateAllProjectsOrFindAllAvailablePomFiles() {
        if (!this.isMavenizedProject()) {
            this.addManagedFiles(this.collectAllAvailablePomFiles());
        }
        this.doScheduleUpdateProjects(null, true, true);
    }

    private AsyncPromise<Void> doScheduleUpdateProjects(Collection<MavenProject> projects, boolean forceUpdate, boolean forceImportAndResolve) {
        AsyncPromise promise = new AsyncPromise();
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> {
            if (projects == null) {
                this.myWatcher.scheduleUpdateAll(forceUpdate, forceImportAndResolve).processed(promise);
            } else {
                this.myWatcher.scheduleUpdate(MavenUtil.collectFiles(projects), Collections.emptyList(), forceUpdate, forceImportAndResolve).processed(promise);
            }
        }));
        return promise;
    }

    public Promise<List<Module>> scheduleImportAndResolve() {
        AsyncPromise<List<Module>> promise = this.scheduleResolve();
        this.fireImportAndResolveScheduled();
        return promise;
    }

    private AsyncPromise<List<Module>> scheduleResolve() {
        AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> {
            LinkedHashSet<MavenProject> toResolve;
            Object object = this.myImportingDataLock;
            synchronized (object) {
                toResolve = new LinkedHashSet<MavenProject>(this.myProjectsToResolve);
                this.myProjectsToResolve.clear();
            }
            if (toResolve.isEmpty()) {
                return;
            }
            ResolveContext context = new ResolveContext();
            Runnable onCompletion = () -> {
                if (this.hasScheduledProjects()) {
                    this.scheduleImport().processed(result);
                } else {
                    result.setResult(Collections.emptyList());
                }
            };
            boolean useSinglePomResolver = Boolean.getBoolean("idea.maven.use.single.pom.resolver");
            if (useSinglePomResolver) {
                Iterator it = toResolve.iterator();
                while (it.hasNext()) {
                    MavenProject each = (MavenProject)it.next();
                    this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(Collections.singleton(each), this.myProjectsTree, this.getGeneralSettings(), it.hasNext() ? null : onCompletion, context));
                }
            } else {
                this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorResolvingTask(toResolve, this.myProjectsTree, this.getGeneralSettings(), onCompletion, context));
            }
        });
        return result;
    }

    public void evaluateEffectivePom(final @NotNull MavenProject mavenProject, final @NotNull NullableConsumer<String> consumer) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsManager", "evaluateEffectivePom"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/maven/project/MavenProjectsManager", "evaluateEffectivePom"));
        }
        this.runWhenFullyOpen(() -> {
            if (mavenProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsManager", "lambda$evaluateEffectivePom$7"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/maven/project/MavenProjectsManager", "lambda$evaluateEffectivePom$7"));
            }
            this.myResolvingProcessor.scheduleTask(new MavenProjectsProcessorTask(){

                @Override
                public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    indicator.setText("Evaluating effective POM");
                    MavenProjectsManager.this.myProjectsTree.executeWithEmbedder(mavenProject, MavenProjectsManager.this.getEmbeddersManager(), MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, console, indicator, new MavenProjectsTree.EmbedderTask(){

                        @Override
                        public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                            try {
                                MavenExplicitProfiles profiles = mavenProject.getActivatedProfilesIds();
                                String res = embedder.evaluateEffectivePom(mavenProject.getFile(), profiles.getEnabledProfiles(), profiles.getDisabledProfiles());
                                consumer.consume((Object)res);
                            }
                            catch (UnsupportedOperationException e) {
                                consumer.consume(null);
                            }
                        }
                    });
                }
            });
        });
    }

    public void scheduleResolveInTests(Collection<MavenProject> projects) {
        this.scheduleForNextResolve(projects);
        this.scheduleResolve();
    }

    public void scheduleResolveAllInTests() {
        this.scheduleResolveInTests(this.getProjects());
    }

    public void scheduleFoldersResolve(Collection<MavenProject> projects) {
        this.runWhenFullyOpen(() -> {
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                MavenProject each = (MavenProject)it.next();
                Runnable onCompletion = it.hasNext() ? null : () -> {
                    if (this.hasScheduledProjects()) {
                        this.scheduleImport();
                    }
                };
                this.myFoldersResolvingProcessor.scheduleTask(new MavenProjectsProcessorFoldersResolvingTask(each, this.getImportingSettings(), this.myProjectsTree, onCompletion));
            }
        });
    }

    public void scheduleFoldersResolveForAllProjects() {
        this.scheduleFoldersResolve(this.getProjects());
    }

    private void schedulePluginsResolve(MavenProject project, NativeMavenProjectHolder nativeMavenProject) {
        this.runWhenFullyOpen(() -> this.myPluginsResolvingProcessor.scheduleTask(new MavenProjectsProcessorPluginsResolvingTask(project, nativeMavenProject, this.myProjectsTree)));
    }

    public void scheduleArtifactsDownloading(Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean sources, boolean docs, @Nullable AsyncResult<MavenArtifactDownloader.DownloadResult> result) {
        if (!sources && !docs) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myArtifactsDownloadingProcessor.scheduleTask(new MavenProjectsProcessorArtifactsDownloadingTask(projects, artifacts, this.myProjectsTree, sources, docs, result)));
    }

    private void scheduleImportSettings() {
        this.scheduleImportSettings(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImportSettings(boolean importModuleGroupsRequired) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        }
        this.scheduleImport();
    }

    private Promise<List<Module>> scheduleImport() {
        final AsyncPromise result = new AsyncPromise();
        this.runWhenFullyOpen(() -> this.myImportingQueue.queue(new Update((Object)this){

            public void run() {
                result.setResult(MavenProjectsManager.this.importProjects());
            }
        }));
        return result;
    }

    public void scheduleImportInTests(List<VirtualFile> projectFiles) {
        ArrayList<Pair<MavenProject, MavenProjectChanges>> toImport = new ArrayList<Pair<MavenProject, MavenProjectChanges>>();
        for (VirtualFile each : projectFiles) {
            MavenProject project = this.findProject(each);
            if (project == null) continue;
            toImport.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)project, (Object)MavenProjectChanges.ALL));
        }
        this.scheduleForNextImport(toImport);
        this.scheduleImport();
    }

    private void scheduleForNextImport(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        this.scheduleForNextImport(Collections.singletonList(projectWithChanges));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextImport(Collection<Pair<MavenProject, MavenProjectChanges>> projectsWithChanges) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            for (Pair<MavenProject, MavenProjectChanges> each : projectsWithChanges) {
                MavenProjectChanges changes = ((MavenProjectChanges)each.second).mergedWith(this.myProjectsToImport.get(each.first));
                this.myProjectsToImport.put((MavenProject)each.first, changes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForNextResolve(Collection<MavenProject> projects) {
        Object object = this.myImportingDataLock;
        synchronized (object) {
            this.myProjectsToResolve.addAll(projects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasScheduledProjects() {
        if (!this.isInitialized()) {
            return false;
        }
        Object object = this.myImportingDataLock;
        synchronized (object) {
            return !this.myProjectsToImport.isEmpty() || !this.myProjectsToResolve.isEmpty();
        }
    }

    public boolean hasScheduledImportsInTests() {
        if (!this.isInitialized()) {
            return false;
        }
        return !this.myImportingQueue.isEmpty();
    }

    public void performScheduledImportInTests() {
        if (!this.isInitialized()) {
            return;
        }
        this.runWhenFullyOpen(() -> this.myImportingQueue.flush());
    }

    private void runWhenFullyOpen(Runnable runnable) {
        if (!this.isInitialized()) {
            return;
        }
        if (this.isNoBackgroundMode()) {
            runnable.run();
            return;
        }
        Ref wrapper = new Ref();
        wrapper.set(() -> {
            if (!StartupManagerEx.getInstanceEx((Project)this.myProject).postStartupActivityPassed()) {
                this.myInitializationAlarm.addRequest(() -> ((Runnable)wrapper.get()).run(), 1000);
                return;
            }
            runnable.run();
        });
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)wrapper.get());
    }

    private void schedulePostImportTasks(List<MavenProjectsProcessorTask> postTasks) {
        for (MavenProjectsProcessorTask each : postTasks) {
            this.myPostProcessor.scheduleTask(each);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unscheduleAllTasks(List<MavenProject> projects) {
        for (MavenProject each : projects) {
            MavenProjectsProcessorEmptyTask dummyTask = new MavenProjectsProcessorEmptyTask(each);
            Object object = this.myImportingDataLock;
            synchronized (object) {
                this.myProjectsToImport.remove(each);
                this.myProjectsToResolve.remove(each);
            }
            this.myResolvingProcessor.removeTask(dummyTask);
            this.myPluginsResolvingProcessor.removeTask(dummyTask);
            this.myFoldersResolvingProcessor.removeTask(dummyTask);
            this.myPostProcessor.removeTask(dummyTask);
        }
    }

    public void unscheduleAllTasksInTests() {
        this.unscheduleAllTasks(this.getProjects());
    }

    public void waitForReadingCompletion() {
        this.waitForTasksCompletion(null);
    }

    public void waitForResolvingCompletion() {
        this.waitForTasksCompletion(this.myResolvingProcessor);
    }

    public void waitForFoldersResolvingCompletion() {
        this.waitForTasksCompletion(this.myFoldersResolvingProcessor);
    }

    public void waitForPluginsResolvingCompletion() {
        this.waitForTasksCompletion(this.myPluginsResolvingProcessor);
    }

    public void waitForArtifactsDownloadingCompletion() {
        this.waitForTasksCompletion(this.myArtifactsDownloadingProcessor);
    }

    public void waitForPostImportTasksCompletion() {
        this.myPostProcessor.waitForCompletion();
    }

    private void waitForTasksCompletion(MavenProjectsProcessor processor) {
        FileDocumentManager.getInstance().saveAllDocuments();
        this.myReadingProcessor.waitForCompletion();
        if (processor != null) {
            processor.waitForCompletion();
        }
    }

    public void updateProjectTargetFolders() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenFoldersImporter.updateProjectFolders(this.myProject, true);
            VirtualFileManager.getInstance().asyncRefresh(null);
        });
    }

    public List<Module> importProjects() {
        return this.importProjects((IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Module> importProjects(final IdeModifiableModelsProvider modelsProvider) {
        boolean importModuleGroupsRequired;
        LinkedHashMap<MavenProject, MavenProjectChanges> projectsToImportWithChanges;
        Object object = this.myImportingDataLock;
        synchronized (object) {
            projectsToImportWithChanges = new LinkedHashMap<MavenProject, MavenProjectChanges>(this.myProjectsToImport);
            this.myProjectsToImport.clear();
            importModuleGroupsRequired = this.myImportModuleGroupsRequired;
            this.myImportModuleGroupsRequired = false;
        }
        Ref importer = new Ref();
        Ref postTasks = new Ref();
        final Runnable r = () -> {
            MavenProjectImporter projectImporter = new MavenProjectImporter(this.myProject, this.myProjectsTree, MavenProjectsManager.getFileToModuleMapping(new MavenModelsProvider(){

                @Override
                public Module[] getModules() {
                    return modelsProvider.getModules();
                }

                @Override
                public VirtualFile[] getContentRoots(Module module) {
                    return modelsProvider.getContentRoots(module);
                }
            }), projectsToImportWithChanges, importModuleGroupsRequired, modelsProvider, this.getImportingSettings());
            importer.set((Object)projectImporter);
            postTasks.set(projectImporter.importProject());
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            r.run();
        } else {
            MavenUtil.runInBackground(this.myProject, ProjectBundle.message("maven.project.importing", new Object[0]), false, new MavenTask(){

                @Override
                public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                    r.run();
                }
            }).waitFor();
        }
        VirtualFileManager fm = VirtualFileManager.getInstance();
        if (this.isNormalProject()) {
            fm.asyncRefresh(null);
        } else {
            fm.syncRefresh();
        }
        if (postTasks.get() != null) {
            this.schedulePostImportTasks((List)postTasks.get());
        }
        this.myImportingQueue.restartTimer();
        MavenProjectImporter projectImporter = (MavenProjectImporter)importer.get();
        if (projectImporter == null) {
            return Collections.emptyList();
        }
        return projectImporter.getCreatedModules();
    }

    private static Map<VirtualFile, Module> getFileToModuleMapping(MavenModelsProvider modelsProvider) {
        THashMap result = new THashMap();
        for (Module each : modelsProvider.getModules()) {
            VirtualFile f = MavenProjectsManager.findPomFile(each, modelsProvider);
            if (f == null) continue;
            result.put(f, each);
        }
        return result;
    }

    private List<VirtualFile> collectAllAvailablePomFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(MavenProjectsManager.getFileToModuleMapping(new MavenDefaultModelsProvider(this.myProject)).keySet());
        for (VirtualFile child : this.myProject.getBaseDir().getChildren()) {
            if (!MavenUtil.isPomFileName(child.getName())) continue;
            result.add(child);
        }
        return result;
    }

    public void addManagerListener(Listener listener) {
        this.myManagerListeners.add(listener);
    }

    public void addProjectsTreeListener(MavenProjectsTree.Listener listener) {
        this.myProjectsTreeDispatcher.addListener((EventListener)listener);
    }

    public void fireActivatedInTests() {
        this.fireActivated();
    }

    private void fireActivated() {
        for (Listener each : this.myManagerListeners) {
            each.activated();
        }
    }

    private void fireProjectScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.projectsScheduled();
        }
    }

    private void fireImportAndResolveScheduled() {
        for (Listener each : this.myManagerListeners) {
            each.importAndResolveScheduled();
        }
    }

    public static interface Listener {
        public void activated();

        public void projectsScheduled();

        public void importAndResolveScheduled();
    }
}

