/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.plugins.api.MavenModelPropertiesPatcher;
import org.jetbrains.idea.maven.project.MavenArtifactIndex;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;

public class MavenProject {
    private static final Key<MavenArtifactIndex> DEPENDENCIES_CACHE_KEY = Key.create((String)"MavenProject.DEPENDENCIES_CACHE_KEY");
    private static final Key<List<String>> FILTERS_CACHE_KEY = Key.create((String)"MavenProject.FILTERS_CACHE_KEY");
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private volatile State myState;

    @Nullable
    public static MavenProject read(DataInputStream in) throws IOException {
        String path = in.readUTF();
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        ObjectInputStream os = new ObjectInputStream(bs);
        try {
            MavenProject result = new MavenProject(file);
            result.myState = (State)os.readObject();
            MavenProject mavenProject = result;
            return mavenProject;
        }
        catch (ClassNotFoundException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
        finally {
            os.close();
            bs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull DataOutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/idea/maven/project/MavenProject", "write"));
        }
        out.writeUTF(this.getPath());
        BufferExposingByteArrayOutputStream bs = new BufferExposingByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);
        try {
            os.writeObject(this.myState);
            out.writeInt(bs.size());
            out.write(bs.getInternalBuffer(), 0, bs.size());
        }
        finally {
            os.close();
            bs.close();
        }
    }

    public MavenProject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/project/MavenProject", "<init>"));
        }
        this.myState = new State();
        this.myFile = file;
    }

    @NotNull
    MavenProjectChanges set(@NotNull MavenProjectReaderResult readerResult, @NotNull MavenGeneralSettings settings, boolean updateLastReadStamp, boolean resetArtifacts, boolean resetProfiles) {
        if (readerResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerResult", "org/jetbrains/idea/maven/project/MavenProject", "set"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/idea/maven/project/MavenProject", "set"));
        }
        State newState = this.myState.clone();
        if (updateLastReadStamp) {
            newState.myLastReadStamp = this.myState.myLastReadStamp + 1L;
        }
        newState.myReadingProblems = readerResult.readingProblems;
        newState.myLocalRepository = settings.getEffectiveLocalRepository();
        newState.myActivatedProfilesIds = readerResult.activatedProfiles;
        MavenModel model = readerResult.mavenModel;
        newState.myMavenId = model.getMavenId();
        if (model.getParent() != null) {
            newState.myParentId = model.getParent().getMavenId();
        }
        newState.myPackaging = model.getPackaging();
        newState.myName = model.getName();
        newState.myFinalName = model.getBuild().getFinalName();
        newState.myDefaultGoal = model.getBuild().getDefaultGoal();
        newState.myBuildDirectory = model.getBuild().getDirectory();
        newState.myOutputDirectory = model.getBuild().getOutputDirectory();
        newState.myTestOutputDirectory = model.getBuild().getTestOutputDirectory();
        MavenProject.doSetFolders(newState, readerResult);
        newState.myFilters = model.getBuild().getFilters();
        newState.myProperties = model.getProperties();
        MavenProject.doSetResolvedAttributes(newState, readerResult, resetArtifacts);
        MavenModelPropertiesPatcher.patch(newState.myProperties, newState.myPlugins);
        newState.myModulesPathsAndNames = this.collectModulePathsAndNames(model, this.getDirectory());
        Collection<String> newProfiles = MavenProject.collectProfilesIds(model.getProfiles());
        if (resetProfiles || newState.myProfilesIds == null) {
            newState.myProfilesIds = newProfiles;
        } else {
            THashSet mergedProfiles = new THashSet(newState.myProfilesIds);
            mergedProfiles.addAll(newProfiles);
            newState.myProfilesIds = new ArrayList<String>((Collection<String>)mergedProfiles);
        }
        newState.myModelMap = readerResult.nativeModelMap;
        MavenProjectChanges mavenProjectChanges = this.setState(newState);
        if (mavenProjectChanges == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "set"));
        }
        return mavenProjectChanges;
    }

    private MavenProjectChanges setState(State newState) {
        MavenProjectChanges changes = this.myState.getChanges(newState);
        this.myState = newState;
        return changes;
    }

    private static void doSetResolvedAttributes(State state, MavenProjectReaderResult readerResult, boolean reset) {
        MavenModel model = readerResult.mavenModel;
        THashSet newUnresolvedArtifacts = new THashSet();
        LinkedHashSet<MavenRemoteRepository> newRepositories = new LinkedHashSet<MavenRemoteRepository>();
        LinkedHashSet<MavenArtifact> newDependencies = new LinkedHashSet<MavenArtifact>();
        LinkedHashSet<MavenArtifactNode> newDependencyTree = new LinkedHashSet<MavenArtifactNode>();
        LinkedHashSet<MavenPlugin> newPlugins = new LinkedHashSet<MavenPlugin>();
        LinkedHashSet<MavenArtifact> newExtensions = new LinkedHashSet<MavenArtifact>();
        if (!reset) {
            if (state.myUnresolvedArtifactIds != null) {
                newUnresolvedArtifacts.addAll(state.myUnresolvedArtifactIds);
            }
            if (state.myRemoteRepositories != null) {
                newRepositories.addAll(state.myRemoteRepositories);
            }
            if (state.myDependencies != null) {
                newDependencies.addAll(state.myDependencies);
            }
            if (state.myDependencyTree != null) {
                newDependencyTree.addAll(state.myDependencyTree);
            }
            if (state.myPlugins != null) {
                newPlugins.addAll(state.myPlugins);
            }
            if (state.myExtensions != null) {
                newExtensions.addAll(state.myExtensions);
            }
        }
        newUnresolvedArtifacts.addAll(readerResult.unresolvedArtifactIds);
        newRepositories.addAll(model.getRemoteRepositories());
        newDependencyTree.addAll(model.getDependencyTree());
        newDependencies.addAll(model.getDependencies());
        newPlugins.addAll(model.getPlugins());
        newExtensions.addAll(model.getExtensions());
        state.myUnresolvedArtifactIds = newUnresolvedArtifacts;
        state.myRemoteRepositories = new ArrayList<MavenRemoteRepository>(newRepositories);
        state.myDependencies = new ArrayList<MavenArtifact>(newDependencies);
        state.myDependencyTree = new ArrayList<MavenArtifactNode>(newDependencyTree);
        state.myPlugins = new ArrayList<MavenPlugin>(newPlugins);
        state.myExtensions = new ArrayList<MavenArtifact>(newExtensions);
    }

    private MavenProjectChanges setFolders(MavenProjectReaderResult readerResult) {
        State newState = this.myState.clone();
        MavenProject.doSetFolders(newState, readerResult);
        return this.setState(newState);
    }

    private static void doSetFolders(State newState, MavenProjectReaderResult readerResult) {
        MavenModel model = readerResult.mavenModel;
        newState.mySources = model.getBuild().getSources();
        newState.myTestSources = model.getBuild().getTestSources();
        newState.myResources = model.getBuild().getResources();
        newState.myTestResources = model.getBuild().getTestResources();
    }

    private Map<String, String> collectModulePathsAndNames(MavenModel mavenModel, String baseDir) {
        String basePath = baseDir + "/";
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> each : this.collectModulesRelativePathsAndNames(mavenModel).entrySet()) {
            result.put(new Path(basePath + each.getKey()).getPath(), each.getValue());
        }
        return result;
    }

    private Map<String, String> collectModulesRelativePathsAndNames(MavenModel mavenModel) {
        String pomFileName = "pom." + StringUtil.notNullize((String)this.myFile.getExtension());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : mavenModel.getModules()) {
            if ((name = name.trim()).length() == 0) continue;
            String originalName = name;
            if (!(name = FileUtil.toSystemIndependentName((String)name)).endsWith("/")) {
                name = name + "/";
            }
            name = name + pomFileName;
            result.put(name, originalName);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(Collection<MavenProfile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        THashSet result = new THashSet(profiles.size());
        for (MavenProfile each : profiles) {
            result.add(each.getId());
        }
        return result;
    }

    public long getLastReadStamp() {
        return this.myState.myLastReadStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getPath() {
        String string = this.myFile.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myFile.getParent().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDirectory"));
        }
        return string;
    }

    @NotNull
    public VirtualFile getDirectoryFile() {
        VirtualFile virtualFile = this.myFile.getParent();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDirectoryFile"));
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getProfilesXmlFile() {
        return MavenUtil.findProfilesXmlFile(this.myFile);
    }

    @Nullable
    public File getProfilesXmlIoFile() {
        return MavenUtil.getProfilesXmlIoFile(this.myFile);
    }

    public boolean hasReadingProblems() {
        return !this.myState.myReadingProblems.isEmpty();
    }

    @Nullable
    public String getName() {
        return this.myState.myName;
    }

    @NotNull
    public String getDisplayName() {
        State state = this.myState;
        if (StringUtil.isEmptyOrSpaces((String)state.myName)) {
            String string = StringUtil.notNullize((String)state.myMavenId.getArtifactId());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDisplayName"));
            }
            return string;
        }
        String string = state.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> getModelMap() {
        Map<String, String> map = this.myState.myModelMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getModelMap"));
        }
        return map;
    }

    @NotNull
    public MavenId getMavenId() {
        MavenId mavenId = this.myState.myMavenId;
        if (mavenId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getMavenId"));
        }
        return mavenId;
    }

    @Nullable
    public MavenId getParentId() {
        return this.myState.myParentId;
    }

    @NotNull
    public String getPackaging() {
        String string = this.myState.myPackaging;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getPackaging"));
        }
        return string;
    }

    @NotNull
    public String getFinalName() {
        String string = this.myState.myFinalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getFinalName"));
        }
        return string;
    }

    @Nullable
    public String getDefaultGoal() {
        return this.myState.myDefaultGoal;
    }

    @NotNull
    public String getBuildDirectory() {
        String string = this.myState.myBuildDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getBuildDirectory"));
        }
        return string;
    }

    @NotNull
    public String getGeneratedSourcesDirectory(boolean testSources) {
        String string = this.getBuildDirectory() + (testSources ? "/generated-test-sources" : "/generated-sources");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getGeneratedSourcesDirectory"));
        }
        return string;
    }

    @NotNull
    public String getAnnotationProcessorDirectory(boolean testSources) {
        if (this.getProcMode() == ProcMode.NONE) {
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            Element cfg = this.getPluginGoalConfiguration(bscMavenPlugin, testSources ? "process-test" : "process");
            if (bscMavenPlugin != null && cfg == null) {
                String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getAnnotationProcessorDirectory"));
                }
                return string;
            }
            if (cfg != null) {
                String out = MavenJDOMUtil.findChildValueByPath(cfg, "outputDirectory");
                if (out == null && (out = MavenJDOMUtil.findChildValueByPath(cfg, "defaultOutputDirectory")) == null) {
                    String string = this.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getAnnotationProcessorDirectory"));
                    }
                    return string;
                }
                if (!new File(out).isAbsolute()) {
                    out = this.getDirectory() + '/' + out;
                }
                String string = out;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getAnnotationProcessorDirectory"));
                }
                return string;
            }
        }
        String def = this.getGeneratedSourcesDirectory(testSources) + (testSources ? "/test-annotations" : "/annotations");
        String string = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), testSources ? "generatedTestSourcesDirectory" : "generatedSourcesDirectory", def);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getAnnotationProcessorDirectory"));
        }
        return string;
    }

    @NotNull
    public ProcMode getProcMode() {
        Element compilerConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (compilerConfiguration == null) {
            compilerConfiguration = this.getCompilerConfig();
        }
        if (compilerConfiguration == null) {
            ProcMode procMode = ProcMode.BOTH;
            if (procMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
            }
            return procMode;
        }
        Element procElement = compilerConfiguration.getChild("proc");
        if (procElement != null) {
            String procMode = procElement.getValue();
            ProcMode procMode2 = "only".equalsIgnoreCase(procMode) ? ProcMode.ONLY : ("none".equalsIgnoreCase(procMode) ? ProcMode.NONE : ProcMode.BOTH);
            if (procMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
            }
            return procMode2;
        }
        String compilerArgument = compilerConfiguration.getChildTextTrim("compilerArgument");
        if ("-proc:none".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.NONE;
            if (procMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
            }
            return procMode;
        }
        if ("-proc:only".equals(compilerArgument)) {
            ProcMode procMode = ProcMode.ONLY;
            if (procMode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
            }
            return procMode;
        }
        Element compilerArguments = compilerConfiguration.getChild("compilerArgs");
        if (compilerArguments != null) {
            for (Element element : compilerArguments.getChildren()) {
                String arg = element.getValue();
                if ("-proc:none".equals(arg)) {
                    ProcMode procMode = ProcMode.NONE;
                    if (procMode == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
                    }
                    return procMode;
                }
                if (!"-proc:only".equals(arg)) continue;
                ProcMode procMode = ProcMode.ONLY;
                if (procMode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
                }
                return procMode;
            }
        }
        ProcMode procMode = ProcMode.BOTH;
        if (procMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProcMode"));
        }
        return procMode;
    }

    public Map<String, String> getAnnotationProcessorOptions() {
        Element compilerConfig = this.getCompilerConfig();
        if (compilerConfig == null) {
            return Collections.emptyMap();
        }
        if (this.getProcMode() != ProcMode.NONE) {
            return MavenProject.getAnnotationProcessorOptionsFromCompilerConfig(compilerConfig);
        }
        MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
        if (bscMavenPlugin != null) {
            return MavenProject.getAnnotationProcessorOptionsFromProcessorPlugin(bscMavenPlugin);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromCompilerConfig(Element compilerConfig) {
        Element compilerArguments;
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        String compilerArgument = compilerConfig.getChildText("compilerArgument");
        MavenProject.addAnnotationProcessorOptionFomrParametersString(compilerArgument, res);
        Element compilerArgs = compilerConfig.getChild("compilerArgs");
        if (compilerArgs != null) {
            for (Element e : compilerArgs.getChildren()) {
                if (!StringUtil.equals((CharSequence)e.getName(), (CharSequence)"arg")) continue;
                String arg = e.getTextTrim();
                MavenProject.addAnnotationProcessorOption(arg, res);
            }
        }
        if ((compilerArguments = compilerConfig.getChild("compilerArguments")) != null) {
            for (Element e : compilerArguments.getChildren()) {
                String name = e.getName();
                if ((name = StringUtil.trimStart((String)name, (String)"-")).length() <= 1 || name.charAt(0) != 'A') continue;
                res.put(name.substring(1), e.getTextTrim());
            }
        }
        return res;
    }

    private static void addAnnotationProcessorOptionFomrParametersString(String compilerArguments, Map<String, String> res) {
        if (!StringUtil.isEmptyOrSpaces((String)compilerArguments)) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(compilerArguments);
            for (String param : parametersList.getParameters()) {
                MavenProject.addAnnotationProcessorOption(param, res);
            }
        }
    }

    private static void addAnnotationProcessorOption(String compilerArg, Map<String, String> optionsMap) {
        if (compilerArg == null || compilerArg.trim().isEmpty()) {
            return;
        }
        if (compilerArg.startsWith("-A")) {
            int idx = compilerArg.indexOf(61, 3);
            if (idx >= 0) {
                optionsMap.put(compilerArg.substring(2, idx), compilerArg.substring(idx + 1));
            } else {
                optionsMap.put(compilerArg.substring(2), "");
            }
        }
    }

    private static Map<String, String> getAnnotationProcessorOptionsFromProcessorPlugin(MavenPlugin bscMavenPlugin) {
        Element cfg = bscMavenPlugin.getGoalConfiguration("process");
        if (cfg == null) {
            cfg = bscMavenPlugin.getConfigurationElement();
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        if (cfg != null) {
            String compilerArguments = cfg.getChildText("compilerArguments");
            MavenProject.addAnnotationProcessorOptionFomrParametersString(compilerArguments, res);
            Element optionsElement = cfg.getChild("options");
            if (optionsElement != null) {
                for (Element option : optionsElement.getChildren()) {
                    res.put(option.getName(), option.getText());
                }
            }
        }
        return res;
    }

    @Nullable
    public List<String> getDeclaredAnnotationProcessors() {
        ArrayList<String> result;
        block7: {
            block6: {
                Element compilerConfig = this.getCompilerConfig();
                if (compilerConfig == null) {
                    return null;
                }
                result = new ArrayList<String>();
                if (this.getProcMode() == ProcMode.NONE) break block6;
                Element processors = compilerConfig.getChild("annotationProcessors");
                if (processors == null) break block7;
                for (Element element : processors.getChildren("annotationProcessor")) {
                    String processorClassName = element.getTextTrim();
                    if (processorClassName.isEmpty()) continue;
                    result.add(processorClassName);
                }
                break block7;
            }
            MavenPlugin bscMavenPlugin = this.findPlugin("org.bsc.maven", "maven-processor-plugin");
            if (bscMavenPlugin != null) {
                Element bscProcessors;
                Element bscCfg = bscMavenPlugin.getGoalConfiguration("process");
                if (bscCfg == null) {
                    bscCfg = bscMavenPlugin.getConfigurationElement();
                }
                if (bscCfg != null && (bscProcessors = bscCfg.getChild("processors")) != null) {
                    for (Element element : bscProcessors.getChildren("processor")) {
                        String processorClassName = element.getTextTrim();
                        if (processorClassName.isEmpty()) continue;
                        result.add(processorClassName);
                    }
                }
            }
        }
        return result;
    }

    @NotNull
    public String getOutputDirectory() {
        String string = this.myState.myOutputDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getOutputDirectory"));
        }
        return string;
    }

    @NotNull
    public String getTestOutputDirectory() {
        String string = this.myState.myTestOutputDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getTestOutputDirectory"));
        }
        return string;
    }

    @NotNull
    public List<String> getSources() {
        List<String> list = this.myState.mySources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getSources"));
        }
        return list;
    }

    @NotNull
    public List<String> getTestSources() {
        List<String> list = this.myState.myTestSources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getTestSources"));
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getResources() {
        List<MavenResource> list = this.myState.myResources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getResources"));
        }
        return list;
    }

    @NotNull
    public List<MavenResource> getTestResources() {
        List<MavenResource> list = this.myState.myTestResources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getTestResources"));
        }
        return list;
    }

    @NotNull
    public List<String> getFilters() {
        List<String> list = this.myState.myFilters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getFilters"));
        }
        return list;
    }

    public List<String> getFilterPropertiesFiles() {
        List<String> res = this.getCachedValue(FILTERS_CACHE_KEY);
        if (res == null) {
            Element files;
            Element propCfg = this.getPluginGoalConfiguration("org.codehaus.mojo", "properties-maven-plugin", "read-project-properties");
            if (propCfg != null && (files = propCfg.getChild("files")) != null) {
                res = new ArrayList<String>();
                for (Element file : files.getChildren("file")) {
                    File f = new File(file.getValue());
                    if (!f.isAbsolute()) {
                        f = new File(this.getDirectory(), file.getValue());
                    }
                    res.add(f.getAbsolutePath());
                }
            }
            if (res == null) {
                res = this.getFilters();
            } else {
                res.addAll(this.getFilters());
            }
            res = this.putCachedValue(FILTERS_CACHE_KEY, res);
        }
        return res;
    }

    @NotNull
    public MavenProjectChanges read(@NotNull MavenGeneralSettings generalSettings, @NotNull MavenExplicitProfiles profiles, @NotNull MavenProjectReader reader, @NotNull MavenProjectReaderProjectLocator locator) {
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "org/jetbrains/idea/maven/project/MavenProject", "read"));
        }
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "org/jetbrains/idea/maven/project/MavenProject", "read"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/idea/maven/project/MavenProject", "read"));
        }
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "org/jetbrains/idea/maven/project/MavenProject", "read"));
        }
        MavenProjectChanges mavenProjectChanges = this.set(reader.readProject(generalSettings, this.myFile, profiles, locator), generalSettings, true, false, true);
        if (mavenProjectChanges == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "read"));
        }
        return mavenProjectChanges;
    }

    @NotNull
    public Pair<MavenProjectChanges, NativeMavenProjectHolder> resolve(@NotNull Project project, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull MavenProjectReader reader, @NotNull MavenProjectReaderProjectLocator locator, @NotNull ResolveContext context) throws MavenProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        if (embedder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embedder", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        if (locator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locator", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        Collection<MavenProjectReaderResult> results = reader.resolveProject(generalSettings, embedder, Collections.singleton(this.getFile()), this.getActivatedProfilesIds(), locator);
        MavenProjectReaderResult result = results.iterator().next();
        MavenProjectChanges changes = this.set(result, generalSettings, false, result.readingProblems.isEmpty(), false);
        if (result.nativeMavenProject != null) {
            for (MavenImporter eachImporter : this.getSuitableImporters()) {
                eachImporter.resolve(project, this, result.nativeMavenProject, embedder, context);
            }
        }
        Pair pair = Pair.create((Object)changes, (Object)result.nativeMavenProject);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "resolve"));
        }
        return pair;
    }

    @NotNull
    public Pair<Boolean, MavenProjectChanges> resolveFolders(@NotNull MavenEmbedderWrapper embedder, @NotNull MavenImportingSettings importingSettings, @NotNull MavenConsole console) throws MavenProcessCanceledException {
        if (embedder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embedder", "org/jetbrains/idea/maven/project/MavenProject", "resolveFolders"));
        }
        if (importingSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importingSettings", "org/jetbrains/idea/maven/project/MavenProject", "resolveFolders"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProject", "resolveFolders"));
        }
        MavenProjectReaderResult result = MavenProjectReader.generateSources(embedder, importingSettings, this.getFile(), this.getActivatedProfilesIds(), console);
        if (result == null || !result.readingProblems.isEmpty()) {
            Pair pair = Pair.create((Object)false, (Object)MavenProjectChanges.NONE);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "resolveFolders"));
            }
            return pair;
        }
        MavenProjectChanges changes = this.setFolders(result);
        Pair pair = Pair.create((Object)true, (Object)changes);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "resolveFolders"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        State state = this.myState;
        synchronized (state) {
            this.myState.resetCache();
        }
    }

    public boolean isAggregator() {
        return "pom".equals(this.getPackaging()) || !this.getModulePaths().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<MavenProjectProblem> getProblems() {
        State state;
        State state2 = state = this.myState;
        // MONITORENTER : state2
        if (state.myProblemsCache == null) {
            state.myProblemsCache = MavenProject.collectProblems(this.myFile, state);
        }
        List<MavenProjectProblem> list = state.myProblemsCache;
        // MONITOREXIT : state2
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProblems"));
    }

    private static List<MavenProjectProblem> collectProblems(VirtualFile file, State state) {
        ArrayList<MavenProjectProblem> result = new ArrayList<MavenProjectProblem>();
        MavenProject.validateParent(file, state, result);
        result.addAll(state.myReadingProblems);
        for (Map.Entry<String, String> each : state.myModulesPathsAndNames.entrySet()) {
            if (LocalFileSystem.getInstance().findFileByPath(each.getKey()) != null) continue;
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.moduleNotFound", each.getValue())));
        }
        MavenProject.validateDependencies(file, state, result);
        MavenProject.validateExtensions(file, state, result);
        MavenProject.validatePlugins(file, state, result);
        return result;
    }

    private static void validateParent(VirtualFile file, State state, List<MavenProjectProblem> result) {
        if (!MavenProject.isParentResolved(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.parentNotFound", state.myParentId)));
        }
    }

    private static void validateDependencies(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedDependencies(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedDependency", each.getDisplayStringWithType())));
        }
    }

    private static void validateExtensions(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenArtifact each : MavenProject.getUnresolvedExtensions(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedExtension", each.getDisplayStringSimple())));
        }
    }

    private static void validatePlugins(VirtualFile file, State state, List<MavenProjectProblem> result) {
        for (MavenPlugin each : MavenProject.getUnresolvedPlugins(state)) {
            result.add(MavenProject.createDependencyProblem(file, ProjectBundle.message("maven.project.problem.unresolvedPlugin", each)));
        }
    }

    private static MavenProjectProblem createDependencyProblem(VirtualFile file, String description) {
        return new MavenProjectProblem(file.getPath(), description, MavenProjectProblem.ProblemType.DEPENDENCY);
    }

    private static boolean isParentResolved(State state) {
        return !state.myUnresolvedArtifactIds.contains(state.myParentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedDependencies(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedDependenciesCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myDependencies) {
                    if (each.isResolved()) continue;
                    result.add(each);
                }
                state.myUnresolvedDependenciesCache = result;
            }
            return state.myUnresolvedDependenciesCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenArtifact> getUnresolvedExtensions(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedExtensionsCache == null) {
                ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
                for (MavenArtifact each : state.myExtensions) {
                    if (!state.myUnresolvedArtifactIds.contains(each.getMavenId()) || MavenProject.pomFileExists(state.myLocalRepository, each)) continue;
                    result.add(each);
                }
                state.myUnresolvedExtensionsCache = result;
            }
            return state.myUnresolvedExtensionsCache;
        }
    }

    private static boolean pomFileExists(File localRepository, MavenArtifact artifact) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, artifact.getMavenId(), "pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MavenPlugin> getUnresolvedPlugins(State state) {
        State state2 = state;
        synchronized (state2) {
            if (state.myUnresolvedPluginsCache == null) {
                ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
                for (MavenPlugin each : MavenProject.getDeclaredPlugins(state)) {
                    if (MavenArtifactUtil.hasArtifactFile(state.myLocalRepository, each.getMavenId())) continue;
                    result.add(each);
                }
                state.myUnresolvedPluginsCache = result;
            }
            return state.myUnresolvedPluginsCache;
        }
    }

    @NotNull
    public List<VirtualFile> getExistingModuleFiles() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        Set<String> pathsInStack = this.getModulePaths();
        for (String each : pathsInStack) {
            VirtualFile f = fs.findFileByPath(each);
            if (f == null) continue;
            result.add(f);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getExistingModuleFiles"));
        }
        return arrayList;
    }

    @NotNull
    public Set<String> getModulePaths() {
        Set<String> set = this.getModulesPathsAndNames().keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getModulePaths"));
        }
        return set;
    }

    @NotNull
    public Map<String, String> getModulesPathsAndNames() {
        Map<String, String> map = this.myState.myModulesPathsAndNames;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getModulesPathsAndNames"));
        }
        return map;
    }

    @NotNull
    public Collection<String> getProfilesIds() {
        Collection<String> collection = this.myState.myProfilesIds;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProfilesIds"));
        }
        return collection;
    }

    @NotNull
    public MavenExplicitProfiles getActivatedProfilesIds() {
        MavenExplicitProfiles mavenExplicitProfiles = this.myState.myActivatedProfilesIds;
        if (mavenExplicitProfiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getActivatedProfilesIds"));
        }
        return mavenExplicitProfiles;
    }

    @NotNull
    public List<MavenArtifact> getDependencies() {
        List<MavenArtifact> list = this.myState.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public List<MavenArtifactNode> getDependencyTree() {
        List<MavenArtifactNode> list = this.myState.myDependencyTree;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDependencyTree"));
        }
        return list;
    }

    @NotNull
    public Set<String> getSupportedPackagings() {
        HashSet result = ContainerUtil.newHashSet((Object[])new String[]{"pom", "jar", "ejb", "ejb-client", "war", "ear", "bundle", "maven-plugin"});
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedPackagings(result);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getSupportedPackagings"));
        }
        return hashSet;
    }

    public Set<String> getDependencyTypesFromImporters(@NotNull SupportedRequestType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/project/MavenProject", "getDependencyTypesFromImporters"));
        }
        THashSet res = new THashSet();
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyTypes((Collection<String>)res, type);
        }
        return res;
    }

    @NotNull
    public Set<String> getSupportedDependencyScopes() {
        THashSet result = new THashSet(Arrays.asList("compile", "provided", "runtime", "test", "system"));
        for (MavenImporter each : this.getSuitableImporters()) {
            each.getSupportedDependencyScopes((Collection<String>)result);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getSupportedDependencyScopes"));
        }
        return tHashSet;
    }

    public void addDependency(@NotNull MavenArtifact dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "org/jetbrains/idea/maven/project/MavenProject", "addDependency"));
        }
        State state = this.myState;
        ArrayList<MavenArtifact> dependenciesCopy = new ArrayList<MavenArtifact>(state.myDependencies);
        dependenciesCopy.add(dependency);
        state.myDependencies = dependenciesCopy;
        state.myCache.clear();
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@NotNull MavenProject depProject) {
        if (depProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depProject", "org/jetbrains/idea/maven/project/MavenProject", "findDependencies"));
        }
        List<MavenArtifact> list = this.findDependencies(depProject.getMavenId());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "findDependencies"));
        }
        return list;
    }

    public List<MavenArtifact> findDependencies(@NotNull MavenId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/project/MavenProject", "findDependencies"));
        }
        return this.getDependencyArtifactIndex().findArtifacts(id);
    }

    @NotNull
    public List<MavenArtifact> findDependencies(@Nullable String groupId, @Nullable String artifactId) {
        List<MavenArtifact> list = this.getDependencyArtifactIndex().findArtifacts(groupId, artifactId);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "findDependencies"));
        }
        return list;
    }

    public boolean hasUnresolvedArtifacts() {
        State state = this.myState;
        return !MavenProject.isParentResolved(state) || !MavenProject.getUnresolvedDependencies(state).isEmpty() || !MavenProject.getUnresolvedExtensions(state).isEmpty();
    }

    public boolean hasUnresolvedPlugins() {
        return !MavenProject.getUnresolvedPlugins(this.myState).isEmpty();
    }

    @NotNull
    public List<MavenPlugin> getPlugins() {
        List<MavenPlugin> list = this.myState.myPlugins;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getPlugins"));
        }
        return list;
    }

    @NotNull
    public List<MavenPlugin> getDeclaredPlugins() {
        List<MavenPlugin> list = MavenProject.getDeclaredPlugins(this.myState);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getDeclaredPlugins"));
        }
        return list;
    }

    private static List<MavenPlugin> getDeclaredPlugins(State state) {
        return ContainerUtil.findAll(state.myPlugins, mavenPlugin -> !mavenPlugin.isDefault());
    }

    @Nullable
    public Element getPluginConfiguration(@Nullable String groupId, @Nullable String artifactId) {
        return this.getPluginGoalConfiguration(groupId, artifactId, null);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable String groupId, @Nullable String artifactId, @Nullable String goal) {
        return this.getPluginGoalConfiguration(this.findPlugin(groupId, artifactId), goal);
    }

    @Nullable
    public Element getPluginGoalConfiguration(@Nullable MavenPlugin plugin, @Nullable String goal) {
        if (plugin == null) {
            return null;
        }
        return goal == null ? plugin.getConfigurationElement() : plugin.getGoalConfiguration(goal);
    }

    public Element getPluginExecutionConfiguration(@Nullable String groupId, @Nullable String artifactId, @NotNull String executionId) {
        if (executionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionId", "org/jetbrains/idea/maven/project/MavenProject", "getPluginExecutionConfiguration"));
        }
        MavenPlugin plugin = this.findPlugin(groupId, artifactId);
        if (plugin == null) {
            return null;
        }
        return plugin.getExecutionConfiguration(executionId);
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId) {
        return this.findPlugin(groupId, artifactId, false);
    }

    @Nullable
    public MavenPlugin findPlugin(@Nullable String groupId, @Nullable String artifactId, boolean explicitlyDeclaredOnly) {
        List<MavenPlugin> plugins = explicitlyDeclaredOnly ? this.getDeclaredPlugins() : this.getPlugins();
        for (MavenPlugin each : plugins) {
            if (!each.getMavenId().equals(groupId, artifactId)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public String getEncoding() {
        String encoding = this.myState.myProperties.getProperty("project.build.sourceEncoding");
        if (encoding != null) {
            return encoding;
        }
        Element pluginConfiguration = this.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (pluginConfiguration != null) {
            return pluginConfiguration.getChildTextTrim("encoding");
        }
        return null;
    }

    @Nullable
    public String getSourceLevel() {
        return this.getCompilerLevel("source");
    }

    @Nullable
    public String getTargetLevel() {
        return this.getCompilerLevel("target");
    }

    @Nullable
    private String getCompilerLevel(String level) {
        String result = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig(), level);
        if (result == null) {
            result = this.myState.myProperties.getProperty("maven.compiler." + level);
        }
        return result;
    }

    @Nullable
    private Element getCompilerConfig() {
        Element executionConfiguration = this.getPluginExecutionConfiguration("org.apache.maven.plugins", "maven-compiler-plugin", "default-compile");
        if (executionConfiguration != null) {
            return executionConfiguration;
        }
        return this.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @NotNull
    public Properties getProperties() {
        Properties properties = this.myState.myProperties;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getProperties"));
        }
        return properties;
    }

    @NotNull
    public File getLocalRepository() {
        File file = this.myState.myLocalRepository;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getLocalRepository"));
        }
        return file;
    }

    @NotNull
    public List<MavenRemoteRepository> getRemoteRepositories() {
        List<MavenRemoteRepository> list = this.myState.myRemoteRepositories;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getRemoteRepositories"));
        }
        return list;
    }

    @NotNull
    public List<MavenImporter> getSuitableImporters() {
        List<MavenImporter> list = MavenImporter.getSuitableImporters(this);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getSuitableImporters"));
        }
        return list;
    }

    @NotNull
    public ModuleType getModuleType() {
        List<MavenImporter> importers = this.getSuitableImporters();
        ModuleType moduleType = importers.size() > 0 ? importers.get(0).getModuleType() : StdModuleTypes.JAVA;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getModuleType"));
        }
        return moduleType;
    }

    @NotNull
    public Pair<String, String> getClassifierAndExtension(@NotNull MavenArtifact artifact, @NotNull MavenExtraArtifactType type) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/project/MavenProject", "getClassifierAndExtension"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/project/MavenProject", "getClassifierAndExtension"));
        }
        for (MavenImporter each : this.getSuitableImporters()) {
            Pair<String, String> result = each.getExtraArtifactClassifierAndExtension(artifact, type);
            if (result == null) continue;
            Pair<String, String> pair = result;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getClassifierAndExtension"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)type.getDefaultClassifier(), (Object)type.getDefaultExtension());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "getClassifierAndExtension"));
        }
        return pair;
    }

    public MavenArtifactIndex getDependencyArtifactIndex() {
        MavenArtifactIndex res = this.getCachedValue(DEPENDENCIES_CACHE_KEY);
        if (res == null) {
            res = MavenArtifactIndex.build(this.getDependencies());
            res = this.putCachedValue(DEPENDENCIES_CACHE_KEY, res);
        }
        return res;
    }

    @Nullable
    public <V> V getCachedValue(Key<V> key) {
        return (V)this.myState.myCache.get(key);
    }

    @NotNull
    public <V> V putCachedValue(Key<V> key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/maven/project/MavenProject", "putCachedValue"));
        }
        ConcurrentHashMap<Key, Object> map = this.myState.myCache;
        Object oldValue = map.putIfAbsent(key, value);
        if (oldValue != null) {
            Object object = oldValue;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "putCachedValue"));
            }
            return (V)object;
        }
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProject", "putCachedValue"));
        }
        return v;
    }

    public String toString() {
        return this.getMavenId().toString();
    }

    private static class State
    implements Cloneable,
    Serializable {
        long myLastReadStamp = 0L;
        MavenId myMavenId;
        MavenId myParentId;
        String myPackaging;
        String myName;
        String myFinalName;
        String myDefaultGoal;
        String myBuildDirectory;
        String myOutputDirectory;
        String myTestOutputDirectory;
        List<String> mySources;
        List<String> myTestSources;
        List<MavenResource> myResources;
        List<MavenResource> myTestResources;
        List<String> myFilters;
        Properties myProperties;
        List<MavenPlugin> myPlugins;
        List<MavenArtifact> myExtensions;
        List<MavenArtifact> myDependencies;
        List<MavenArtifactNode> myDependencyTree;
        List<MavenRemoteRepository> myRemoteRepositories;
        Map<String, String> myModulesPathsAndNames;
        Map<String, String> myModelMap;
        Collection<String> myProfilesIds;
        MavenExplicitProfiles myActivatedProfilesIds;
        Collection<MavenProjectProblem> myReadingProblems;
        Set<MavenId> myUnresolvedArtifactIds;
        File myLocalRepository;
        volatile List<MavenProjectProblem> myProblemsCache;
        volatile List<MavenArtifact> myUnresolvedDependenciesCache;
        volatile List<MavenPlugin> myUnresolvedPluginsCache;
        volatile List<MavenArtifact> myUnresolvedExtensionsCache;
        transient ConcurrentHashMap<Key, Object> myCache = new ConcurrentHashMap();

        private State() {
        }

        public State clone() {
            try {
                State result = (State)super.clone();
                this.myCache = new ConcurrentHashMap();
                result.resetCache();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void resetCache() {
            this.myProblemsCache = null;
            this.myUnresolvedDependenciesCache = null;
            this.myUnresolvedPluginsCache = null;
            this.myUnresolvedExtensionsCache = null;
            this.myCache.clear();
        }

        public MavenProjectChanges getChanges(State other) {
            if (this.myLastReadStamp == 0L) {
                return MavenProjectChanges.ALL;
            }
            MavenProjectChanges result = new MavenProjectChanges();
            result.packaging = !Comparing.equal((String)this.myPackaging, (String)other.myPackaging);
            result.output = !Comparing.equal((String)this.myFinalName, (String)other.myFinalName) || !Comparing.equal((String)this.myBuildDirectory, (String)other.myBuildDirectory) || !Comparing.equal((String)this.myOutputDirectory, (String)other.myOutputDirectory) || !Comparing.equal((String)this.myTestOutputDirectory, (String)other.myTestOutputDirectory);
            result.sources = !Comparing.equal(this.mySources, other.mySources) || !Comparing.equal(this.myTestSources, other.myTestSources) || !Comparing.equal(this.myResources, other.myResources) || !Comparing.equal(this.myTestResources, other.myTestResources);
            boolean repositoryChanged = !Comparing.equal((Object)this.myLocalRepository, (Object)other.myLocalRepository);
            result.dependencies = repositoryChanged || !Comparing.equal(this.myDependencies, other.myDependencies);
            result.plugins = repositoryChanged || !Comparing.equal(this.myPlugins, other.myPlugins);
            return result;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.myCache = new ConcurrentHashMap();
        }
    }

    public static enum ProcMode {
        BOTH,
        ONLY,
        NONE;

    }
}

