/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.HashMap;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedDataHolder {
    private static final Key<Pair<String, String>> DEFAULT_SERVER = Key.create((String)"default_server");
    private static final Key<Map<String, List<DeploymentPathMapping>>> MAPPINGS = Key.create((String)"mappings");
    private static final Key<Map<String, List<ExcludedPath>>> EXCLUDED_PATHS = Key.create((String)"excluded.paths.from.mappings.key");
    private final Map<Key, EventDispatcher<ChangeListener>> myEventDispatchers = new java.util.HashMap<Key, EventDispatcher<ChangeListener>>();
    private final UserDataHolderBase myHolder = new UserDataHolderBase();

    @NotNull
    public Pair<String, String> getDefaultServerIdAndName() {
        Pair<String, String> data = this.getUserData(DEFAULT_SERVER);
        if (data == null) {
            this.setDefaultServer(null, null);
            Pair<String, String> pair = this.getDefaultServerIdAndName();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getDefaultServerIdAndName"));
            }
            return pair;
        }
        Pair<String, String> pair = data;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getDefaultServerIdAndName"));
        }
        return pair;
    }

    public void setDefaultServer(@Nullable String id, @Nullable String name) {
        this.setDefaultServer((Pair<String, String>)Pair.create((Object)id, (Object)name));
    }

    public void setDefaultServer(Pair<String, String> idAndName) {
        this.putUserData(DEFAULT_SERVER, idAndName);
    }

    public void addDefaultServerListener(@NotNull ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "addDefaultServerListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "addDefaultServerListener"));
        }
        this.addListener(DEFAULT_SERVER, listener, parent);
    }

    @NotNull
    public Map<String, List<DeploymentPathMapping>> getMappings() {
        Map<String, List<DeploymentPathMapping>> data = this.getUserData(MAPPINGS);
        if (data == null) {
            this.setMappings((Map<String, List<DeploymentPathMapping>>)new HashMap());
            Map<String, List<DeploymentPathMapping>> map = this.getMappings();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getMappings"));
            }
            return map;
        }
        Map<String, List<DeploymentPathMapping>> map = data;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getMappings"));
        }
        return map;
    }

    public void setMappings(Map<String, List<DeploymentPathMapping>> mappings) {
        this.putUserData(MAPPINGS, mappings);
    }

    @NotNull
    public Map<String, List<ExcludedPath>> getExcludedPaths() {
        Map<String, List<ExcludedPath>> data = this.getUserData(EXCLUDED_PATHS);
        if (data == null) {
            this.setExcludedPaths((Map<String, List<ExcludedPath>>)new HashMap());
            Map<String, List<ExcludedPath>> map = this.getExcludedPaths();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getExcludedPaths"));
            }
            return map;
        }
        Map<String, List<ExcludedPath>> map = data;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "getExcludedPaths"));
        }
        return map;
    }

    public void setExcludedPaths(Map<String, List<ExcludedPath>> excludedPaths) {
        this.putUserData(EXCLUDED_PATHS, excludedPaths);
    }

    private <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "putUserData"));
        }
        this.myHolder.putUserData(key, value);
        this.fireChanged(key);
    }

    private <T> T getUserData(Key<T> key) {
        return (T)this.myHolder.getUserData(key);
    }

    private void fireChanged(Key key) {
        if (key != null) {
            EventDispatcher<ChangeListener> dispatcher = this.myEventDispatchers.get(key);
            if (dispatcher != null) {
                ((ChangeListener)dispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        } else {
            ChangeEvent e = new ChangeEvent(this);
            for (EventDispatcher<ChangeListener> dispatcher : this.myEventDispatchers.values()) {
                ((ChangeListener)dispatcher.getMulticaster()).stateChanged(e);
            }
        }
    }

    private void addListener(Key key, @NotNull ChangeListener l, @NotNull Disposable parentDisposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "addListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/jetbrains/plugins/webDeployment/ui/config/SharedDataHolder", "addListener"));
        }
        EventDispatcher dispatcher = this.myEventDispatchers.get(key);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(ChangeListener.class);
            this.myEventDispatchers.put(key, (EventDispatcher<ChangeListener>)dispatcher);
        }
        dispatcher.addListener((EventListener)l, parentDisposable);
    }
}

