/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SyncUtils {
    @NonNls
    private static final String EXCLUDED_FROM_PROJECT_PATHS_KEY = "excludedFromProjectPaths";

    private SyncUtils() {
    }

    public static void initializeExcludedFromProjectFiles(DirDiffSettings settings, List<DiffRoot> roots, Deployable config, Project project) {
        List<String> excludedPaths = SyncUtils.collectExcludedChildFiles(roots, config, project);
        settings.customSettings.put(EXCLUDED_FROM_PROJECT_PATHS_KEY, excludedPaths);
    }

    @NotNull
    private static List<String> getExcludedFromProjectPaths(DirDiffSettings settings) {
        List list = (List)settings.customSettings.get(EXCLUDED_FROM_PROJECT_PATHS_KEY);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/SyncUtils", "getExcludedFromProjectPaths"));
        }
        return list;
    }

    private static List<String> collectExcludedChildFiles(List<DiffRoot> roots, Deployable serverConfig, Project project) {
        ArrayList<String> excludedChildFiles = new ArrayList<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile excludeRoot : rootManager.getExcludeRoots()) {
                excludedChildFiles.add(excludeRoot.getPath());
            }
        }
        Iterator it = excludedChildFiles.iterator();
        while (it.hasNext()) {
            String excludedString = (String)it.next();
            boolean found = false;
            for (DiffRoot root : roots) {
                String localPath;
                String string = localPath = root.getLocal() == null ? root.getMapping().mapToLocalPath(root.getRemote().getName(), (Mappable)serverConfig) : root.getLocal().getPath();
                if (!FileUtil.isAncestor((String)localPath, (String)excludedString, (boolean)false) && !FileUtil.isAncestor((String)excludedString, (String)localPath, (boolean)false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
        }
        return excludedChildFiles;
    }

    public static boolean isLocalPathExcludedFromProject(String localPath, DirDiffSettings settings) {
        return SyncUtils.isLocalPathExcludedFromProject(localPath, SyncUtils.getExcludedFromProjectPaths(settings));
    }

    private static boolean isLocalPathExcludedFromProject(String localPath, List<String> excludedFromProjectFiles) {
        for (String file : excludedFromProjectFiles) {
            if (!FileUtil.isAncestor((String)file, (String)localPath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcludedRemoteOrCorresponding(FileObject remoteItem, DeploymentPathMapping mapping, Deployable server, PublishConfig config, DirDiffSettings diffSettings) {
        if (config.isExcludedByName(server.getPresentablePath(remoteItem))) {
            return true;
        }
        boolean excluded = PublishConfig.isRemotePathExcluded(remoteItem.getName(), (Mappable)server, config);
        if (!excluded) {
            String localPath = mapping.mapToLocalPath(remoteItem, (Mappable)server);
            excluded = PublishConfig.isLocalPathExcluded(localPath, server, config);
            excluded |= SyncUtils.isLocalPathExcludedFromProject(localPath, diffSettings);
        }
        return excluded;
    }

    public static boolean isExcludedLocalOrCorresponding(String localItemPath, DeploymentPathMapping mapping, Deployable server, PublishConfig config, DirDiffSettings diffSettings) {
        if (config.isExcludedByName(localItemPath)) {
            return true;
        }
        boolean excluded = PublishConfig.isLocalPathExcluded(localItemPath, server, config);
        if (!(excluded |= SyncUtils.isLocalPathExcludedFromProject(localItemPath, diffSettings))) {
            WebServerConfig.RemotePath remotePath = mapping.mapToDeployPath(localItemPath, (Mappable)server);
            excluded = PublishConfig.isRemotePathExcluded(remotePath, (Mappable)server, config);
        }
        return excluded;
    }
}

