/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PropertyProvider {
    private final PropertiesComponent myProperties;
    private final String myKey;

    public PropertyProvider(@NotNull Project project, @NotNull String key, @NotNull String defaultValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/PropertyProvider", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/ui/PropertyProvider", "<init>"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/jetbrains/plugins/webDeployment/ui/PropertyProvider", "<init>"));
        }
        this(project, key);
        this.initDefault(defaultValue);
    }

    public void initDefault(String defaultValue) {
        if (!this.myProperties.isValueSet(this.myKey)) {
            this.saveValue(defaultValue);
        }
    }

    public PropertyProvider(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/PropertyProvider", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/plugins/webDeployment/ui/PropertyProvider", "<init>"));
        }
        this.myKey = key;
        this.myProperties = PropertiesComponent.getInstance((Project)project);
    }

    public String readValue() {
        if (this.myProperties.isValueSet(this.myKey)) {
            return this.myProperties.getValue(this.myKey);
        }
        throw new AssertionError((Object)"no stored value");
    }

    public void saveValue(String value) {
        this.myProperties.setValue(this.myKey, value);
    }
}

