/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRoot
extends LocalMappingDiffRoot {
    @NotNull
    private final FileObject remoteFile;

    private DiffRoot(@Nullable VirtualFile localFile, @NotNull FileObject remoteFile, @NotNull DeploymentPathMapping mapping) {
        if (remoteFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteFile", "com/jetbrains/plugins/webDeployment/ui/DiffRoot", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/jetbrains/plugins/webDeployment/ui/DiffRoot", "<init>"));
        }
        super(localFile, mapping);
        this.remoteFile = remoteFile;
    }

    @NotNull
    public FileObject getRemote() {
        FileObject fileObject = this.remoteFile;
        if (fileObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/DiffRoot", "getRemote"));
        }
        return fileObject;
    }

    public static DiffRoot create(VirtualFile local, FileObject remote, DeploymentPathMapping mapping) {
        return new DiffRoot(local, remote, mapping);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DiffRoot{");
        sb.append("\nlocalFile=").append(this.getLocal().getName());
        sb.append("\nmapping=").append(this.getMapping());
        sb.append("\nremoteFile=").append(this.remoteFile.getName().getBaseName());
        sb.append('}');
        return sb.toString();
    }
}

