/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.sync;

import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.popup.SetOperationToBase;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MirrorBaseAction
extends AnAction {
    private final boolean myCopyToLeft;

    protected MirrorBaseAction(boolean from) {
        this.myCopyToLeft = from;
    }

    public void actionPerformed(AnActionEvent e) {
        DirDiffTableModel model = SetOperationToBase.getModel((AnActionEvent)e);
        JTable table = MirrorBaseAction.getTable(e);
        assert (model != null && table != null);
        for (DirDiffElementImpl element : model.getSelectedElements()) {
            element.setOperation(MirrorBaseAction.getOperation(this.myCopyToLeft, element));
        }
        table.repaint();
    }

    @NotNull
    private static DirDiffOperation getOperation(boolean copyFrom, DirDiffElementImpl element) {
        if (copyFrom) {
            if (element.isSource()) {
                DirDiffOperation dirDiffOperation = DirDiffOperation.DELETE;
                if (dirDiffOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/sync/MirrorBaseAction", "getOperation"));
                }
                return dirDiffOperation;
            }
            DirDiffOperation dirDiffOperation = DirDiffOperation.COPY_FROM;
            if (dirDiffOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/sync/MirrorBaseAction", "getOperation"));
            }
            return dirDiffOperation;
        }
        if (element.isTarget()) {
            DirDiffOperation dirDiffOperation = DirDiffOperation.DELETE;
            if (dirDiffOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/sync/MirrorBaseAction", "getOperation"));
            }
            return dirDiffOperation;
        }
        DirDiffOperation dirDiffOperation = DirDiffOperation.COPY_TO;
        if (dirDiffOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/sync/MirrorBaseAction", "getOperation"));
        }
        return dirDiffOperation;
    }

    public final void update(AnActionEvent e) {
        DirDiffTableModel model = SetOperationToBase.getModel((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible(model != null && MirrorBaseAction.getTable(e) != null && model.getSettings().customSettings.get("syncLoadComponent") != null);
    }

    @Nullable
    private static JTable getTable(AnActionEvent e) {
        return (JTable)e.getData(DirDiffPanel.DIR_DIFF_TABLE);
    }
}

