/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.FileContentQueue;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesUploadingService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import com.jetbrains.plugins.webDeployment.ui.OverwriteRemoteWarningDialog;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteEditUploadFilesTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)RemoteEditUploadFilesTask.class.getName());
    private static final String MESSAGES_TITLE = WDBundle.message("remote.edit.remote.file.upload.messages.title", new Object[0]);
    protected final ConnectionOwner myConnectionOwner;
    @NotNull
    private final FileContentQueue myQueue;
    private volatile boolean myProjectCloseRequested;
    private volatile boolean myFinished;

    public RemoteEditUploadFilesTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull FileContentQueue queue) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "<init>"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "<init>"));
        }
        super(project, title, true, new PerformInBackgroundOption(){

            public void processSentToBackground() {
            }

            public boolean shouldStartInBackground() {
                return true;
            }
        });
        this.myConnectionOwner = connectionOwner;
        this.myQueue = queue;
    }

    public boolean isConditionalModal() {
        return true;
    }

    public void run(@NotNull ProgressIndicator pi) {
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "run"));
        }
        this.doRun(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void doRun(final @NotNull ProgressIndicator pi) {
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "doRun"));
        }
        LOG.assertTrue(!this.myFinished);
        ProjectManagerAdapter listener = null;
        if (this.myProject != null) {
            listener = new ProjectManagerAdapter(){

                public boolean canCloseProject(Project project) {
                    String title = WDBundle.message("warning.running.dialog.title", RemoteEditUploadFilesTask.this.getTitle());
                    String text = WDBundle.message("warning.running.on.project.close", RemoteEditUploadFilesTask.this.getTitle());
                    int result = Messages.showOkCancelDialog((Project)RemoteEditUploadFilesTask.this.myProject, (String)text, (String)title, (Icon)Messages.getQuestionIcon());
                    if (result != 0) {
                        return false;
                    }
                    RemoteEditUploadFilesTask.this.myProjectCloseRequested = true;
                    pi.cancel();
                    return RemoteEditUploadFilesTask.this.myFinished;
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)listener);
        }
        try {
            Pair<RemoteVirtualFile, byte[]> next;
            while ((next = this.myQueue.getNextFile()) != null) {
                RemoteConnection connection = ((RemoteVirtualFile)((Object)next.getFirst())).getClonedConnection();
                try {
                    this.uploadFile(pi, next, connection);
                }
                finally {
                    if (connection == null) continue;
                    connection.release();
                }
            }
            return;
        }
        catch (ProcessCanceledException e) {
            LOG.debug("cancelled");
            return;
        }
        finally {
            this.myFinished = true;
            if (listener != null && this.myProject != null) {
                ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)listener);
            }
            if (this.myProjectCloseRequested && this.myProject != null) {
                ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.closeAndDispose((Project)this.myProject));
            }
        }
    }

    private void uploadFile(final @NotNull ProgressIndicator pi, Pair<RemoteVirtualFile, byte[]> next, RemoteConnection connection) {
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/remoteEdit/RemoteEditUploadFilesTask", "uploadFile"));
        }
        final RemoteVirtualFile file = (RemoteVirtualFile)((Object)next.getFirst());
        pi.setText(WDBundle.message("remote.edit.uploading.content.of", new Object[0]) + file.getPath() + "'");
        Deployable serverConfig = file.getServerConfig();
        final byte[] content = (byte[])next.getSecond();
        final FileObject dest = file.getDestination();
        final ExecutionContext context = this.myQueue.createContext(serverConfig, this.myProject, pi);
        pi.checkCanceled();
        final Ref exceptionHolder = Ref.create();
        boolean triedToUpload = connection.executeServerOperation(new Computable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean compute() {
                OutputStream out = null;
                try {
                    DeploymentPathUtils.refreshRemoteFile(dest, context);
                    if (RemoteEditUploadFilesTask.this.handleChangedRemote(dest, file, pi)) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    out = dest.getContent().getOutputStream();
                    FileTransferUtil.writeContent(content, out, context);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    exceptionHolder.set((Object)e);
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                return Boolean.TRUE;
            }
        }, pi);
        if (!triedToUpload) {
            return;
        }
        IOException exception = (IOException)exceptionHolder.get();
        if (exception == null) {
            file.updateLastSyncedContent(content);
        }
        RemoteEditEditorDecorator.updateDecorators(file);
        if (exception != null) {
            String message = WDBundle.message("remote.edit.failed.to.upload.content.of.remote.file.0.from.server.1.n.2", file.getPath(), file.getServerConfig().getName(), exception.getMessage());
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)MESSAGES_TITLE));
        }
        pi.setText("");
    }

    private boolean handleChangedRemote(FileObject dest, final RemoteVirtualFile file, ProgressIndicator pi) throws IOException {
        if (!dest.exists()) {
            return (Boolean)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return 0 != Messages.showOkCancelDialog((Project)RemoteEditUploadFilesTask.this.myProject, (String)WDBundle.message("remote.edit.file.0.was.deleted.on.1.server", file.getName(), file.getServerConfig().getName()), (String)MESSAGES_TITLE, (String)WDBundle.message("remote.edit.upload", new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)Messages.getQuestionIcon());
                }
            });
        }
        byte[] oldContent = FileTransferUtil.getContent(dest, pi);
        if (!file.isChanged(oldContent)) {
            return false;
        }
        ApplicationManager.getApplication().invokeLater(() -> this.suggestToMerge(oldContent, file, dest));
        return true;
    }

    private void suggestToMerge(byte[] remoteContent, RemoteVirtualFile file, FileObject dest) {
        OverwriteRemoteWarningDialog dialog = OverwriteRemoteWarningDialog.createInstance(this.myConnectionOwner, dest, file.getServerConfig(), false);
        dialog.setTitle(MESSAGES_TITLE);
        dialog.setSkipActionTitle(CommonBundle.getCancelButtonText());
        dialog.showAndGet();
        OverwriteRemoteWarningDialog.OverwriteOption overwriteOption = dialog.getResult();
        switch (overwriteOption) {
            case OVERWRITE: {
                file.updateLastSyncedContent(remoteContent);
                RemoteEditedFilesUploadingService.getInstance(this.myProject).queueUpload(file);
                return;
            }
            case SKIP: {
                return;
            }
            case MERGE: {
                this.merge(remoteContent, file);
                return;
            }
        }
        LOG.error("Unexpected result: " + (Object)((Object)overwriteOption));
    }

    private void merge(byte[] remoteContent, RemoteVirtualFile file) {
        byte[] baseContent;
        try {
            baseContent = file.contentsToByteArray();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String message = WDBundle.message("remote.edit.failed.to.upload", file.getPath(), file.getServerConfig().getName());
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)MESSAGES_TITLE));
            return;
        }
        byte[] lastSyncedContent = file.getLastSyncedContent();
        String windowTitle = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
        List titles = ContainerUtil.list((Object[])new String[]{WDBundle.message("remote.edit.last.uploaded", new Object[0]), WDBundle.message("remote.edit.current.content", new Object[0]), WDBundle.message("remote.edit.remote.file.content", new Object[0])});
        List contents = ContainerUtil.list((Object[])new byte[][]{lastSyncedContent, baseContent, remoteContent});
        Consumer callback = result -> {
            if (result != MergeResult.CANCEL) {
                Document document = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                file.updateLastSyncedContent(remoteContent);
                RemoteEditedFilesUploadingService.getInstance(this.myProject).queueUpload(file);
            }
        };
        try {
            TextMergeRequest request = DiffRequestFactory.getInstance().createTextMergeRequest(this.myProject, (VirtualFile)file, contents, windowTitle, titles, callback);
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, PublishUtils.getMergeResolveCaptions());
            DiffManager.getInstance().showMerge(this.myProject, (MergeRequest)request);
        }
        catch (InvalidDiffRequestException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean isFinished() {
        return this.myFinished;
    }
}

