/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionPool;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionManager
implements DeploymentConfigChangeListener {
    public static final String DEFAULT_IDE_FTP_SYSTEM_TYPE = "UNIX default system type provided by IDE";
    private final Object LOCK = new Object();
    private final Map<ConnectionKey, RemoteConnectionPool> myPools = new TreeMap<ConnectionKey, RemoteConnectionPool>();

    public static RemoteConnectionManager getInstance() {
        return (RemoteConnectionManager)ServiceManager.getService(RemoteConnectionManager.class);
    }

    public RemoteConnectionManager() {
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)this);
        if (System.getProperty("org.apache.commons.net.ftp.systemType.default") == null) {
            System.setProperty("org.apache.commons.net.ftp.systemType.default", DEFAULT_IDE_FTP_SYSTEM_TYPE);
        }
        this.deploymentConfigChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConnection openConnection(@NotNull ConnectionOwner connectionOwner, @NotNull String title, @NotNull Connectable connectable, @NotNull FileTransferConfig.Origin origin, @Nullable EventDispatcher<ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        RemoteConnectionPool pool;
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager", "openConnection"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager", "openConnection"));
        }
        if (connectable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectable", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager", "openConnection"));
        }
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionManager", "openConnection"));
        }
        final ConnectionKey key = new ConnectionKey(connectable.getRootUri(), connectable.getConnectionOptions(connectionOwner, title, origin, forceDisconnectDispatcher, pi));
        Object object = this.LOCK;
        synchronized (object) {
            pool = this.myPools.get(key);
            if (pool == null) {
                pool = new RemoteConnectionPool(connectable, connectionOwner, title, origin);
                this.myPools.put(key, pool);
                connectionOwner.registerDisposable(new Disposable(){

                    public void dispose() {
                        if (ApplicationManager.getApplication().isDispatchThread()) {
                            ApplicationManager.getApplication().executeOnPooledThread(() -> this.doDispose());
                        } else {
                            this.doDispose();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void doDispose() {
                        RemoteConnectionPool pool;
                        Object object = RemoteConnectionManager.this.LOCK;
                        synchronized (object) {
                            pool = (RemoteConnectionPool)RemoteConnectionManager.this.myPools.remove(key);
                        }
                        if (pool != null) {
                            pool.close();
                        }
                    }
                });
            }
        }
        return pool.createConnection(forceDisconnectDispatcher, pi);
    }

    @Override
    public void deploymentConfigChanged() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Object object = this.LOCK;
            synchronized (object) {
                List<WebServerConfig> newServers = WebServersConfigManagerImpl.getServersFromAllOpenProjects(false);
                for (WebServerConfig newServer : newServers) {
                    for (RemoteConnectionPool pool : this.myPools.values()) {
                        pool.notifyServerUpdated(newServer);
                    }
                }
            }
        });
    }

    @Override
    public void optionsChanged() {
    }

    @Override
    public void excludedPathsChanged() {
    }

    private static class ConnectionKey
    implements Comparable<ConnectionKey> {
        private final String myUri;
        private final FileSystemOptions myFileSystemOptions;

        private ConnectionKey(String uri, FileSystemOptions fileSystemOptions) {
            this.myUri = uri;
            this.myFileSystemOptions = fileSystemOptions;
        }

        @Override
        public int compareTo(ConnectionKey o) {
            int i = this.myUri.compareTo(o.myUri);
            if (i == 0) {
                i = this.myFileSystemOptions.compareTo(o.myFileSystemOptions);
            }
            return i;
        }
    }

    public static interface ForceDisconnectListener
    extends EventListener {
        public void forceDisconnect();
    }
}

