/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.EditorNotificationPanel;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.CompareLocalVsRemoteTask;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteChangeNotificationPanelCreator {
    private static final Logger LOG = Logger.getInstance(RemoteChangeNotificationPanelCreator.class);
    @NotNull
    protected final Project myProject;
    protected final VirtualFile myFile;

    protected RemoteChangeNotificationPanelCreator(VirtualFile file, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator", "<init>"));
        }
        this.myFile = file;
        this.myProject = project;
    }

    public abstract EditorNotificationPanel createPanel(@NotNull FileEditor var1);

    public static class Cancel
    extends RemoteChangeNotificationPanelCreator {
        private final Deployable myServer;
        private final PublishConfig myConfig;

        public Cancel(VirtualFile file, @NotNull Project project, PublishConfig publishConfig, Deployable server) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Cancel", "<init>"));
            }
            super(file, project);
            this.myServer = server;
            this.myConfig = publishConfig;
        }

        @Override
        public EditorNotificationPanel createPanel(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Cancel", "createPanel"));
            }
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(WDBundle.message("remote.file.check.was.cancelled", new Object[0]));
            panel.createActionLabel(WDBundle.message("retry.command", new Object[0]), () -> RemoteChangeNotifier.getInstance(this.myProject).updateNotifications(this.myFile, this.myConfig, this.myServer)).setToolTipText(WDBundle.message("retry.command", new Object[0]));
            panel.createActionLabel(WDBundle.message("hide", new Object[0]), () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Cancel", "lambda$createPanel$1"));
                }
                RemoteChangeNotifier.getInstance(this.myProject).hideNotification(this.myFile, editor);
            }).setToolTipText(WDBundle.message("hide", new Object[0]));
            panel.createActionLabel(WDBundle.message("open.options", new Object[0]), () -> ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new PublishOptionsConfigurable(this.myProject))).setToolTipText(WDBundle.message("open.options", new Object[0]));
            return panel;
        }
    }

    public static class Update
    extends RemoteChangeNotificationPanelCreator {
        private final Deployable myServer;
        @Nullable
        private final DeploymentRevisionTracker.Revision myRevision;
        private final PublishConfig myConfig;

        public Update(VirtualFile file, Deployable server, PublishConfig publishConfig, @Nullable DeploymentRevisionTracker.Revision revision, @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Update", "<init>"));
            }
            super(file, project);
            this.myServer = server;
            this.myRevision = revision;
            this.myConfig = publishConfig;
        }

        @Override
        public EditorNotificationPanel createPanel(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Update", "createPanel"));
            }
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(this.myRevision == null ? WDBundle.message("file.needs.to.be.synchronized", this.myServer.getName()) : WDBundle.message("remote.file.on.0.is.changed", this.myServer.getName()));
            if (!this.myFile.getFileType().isBinary()) {
                panel.createActionLabel(WDBundle.message("action.title.merge", new Object[0]), () -> {
                    AutoUploadComponent.saveDocumentsSilently(this.myProject, Collections.singleton(this.myFile));
                    Update.queueDownloadTask(this.myProject, this.myConfig, this.myServer, this.myFile, DeploymentMode.SAFE);
                }).setToolTipText(WDBundle.message("action.description.merge.local.and.remote.versions.in.local.file", new Object[0]));
            }
            panel.createActionLabel(WDBundle.message("action.name.download", new Object[0]), () -> {
                AutoUploadComponent.saveDocumentsSilently(this.myProject, Collections.singleton(this.myFile));
                Update.queueDownloadTask(this.myProject, this.myConfig, this.myServer, this.myFile, DeploymentMode.CUSTOM);
            }).setToolTipText(WDBundle.message("action.description.download.remote.version.from.0", this.myServer.getName()));
            return panel;
        }

        private static void queueDownloadTask(@NotNull Project project, PublishConfig publishConfig, Deployable server, final VirtualFile file, DeploymentMode mode) {
            String title;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Update", "queueDownloadTask"));
            }
            String string = title = mode == DeploymentMode.SAFE ? WDBundle.message("update.from.0", server.getName()) : WDBundle.message("download.from", server.getName());
            if (mode == DeploymentMode.CUSTOM) {
                publishConfig = publishConfig.clone();
                publishConfig.setPromptOnLocalOverwrite(false);
            }
            FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
            new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), false, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project), mode){

                @Override
                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                    ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                    DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(DeploymentPathUtils.getLocalFile(file.getPath()), context, result);
                    errors.addAll(e);
                    return new TransferTask.ListBased.ResultWithErrors(result, errors);
                }
            }.queue();
        }
    }

    public static class Delete
    extends RemoteChangeNotificationPanelCreator {
        private final Deployable myServer;

        public Delete(VirtualFile file, Deployable server, @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Delete", "<init>"));
            }
            super(file, project);
            this.myServer = server;
        }

        @Override
        public EditorNotificationPanel createPanel(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$Delete", "createPanel"));
            }
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(WDBundle.message("remote.file.on.0.is.removed", this.myServer.getName()));
            panel.createActionLabel(WDBundle.message("delete.local.file", new Object[0]), () -> {
                AutoUploadComponent.saveDocumentsSilently(this.myProject, Collections.singleton(this.myFile));
                PsiFile psiFile = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().findFile(this.myFile);
                if (psiFile != null) {
                    SafeDeleteHandler.invoke((Project)this.myProject, (PsiElement[])new PsiElement[]{psiFile}, (boolean)false, null);
                } else {
                    AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(RemoteChangeNotificationPanelCreator.class);
                    try {
                        this.myFile.delete((Object)RemoteChangeNotificationPanelCreator.class.toString());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        token.finish();
                    }
                }
            }).setToolTipText(WDBundle.message("delete.local.file", new Object[0]));
            return panel;
        }
    }

    public static class TooLargeFile
    extends RemoteChangeNotificationPanelCreator {
        private final Deployable myServer;
        private final FileObject myRemoteFile;
        private final DeploymentPathMapping myMapping;

        public TooLargeFile(VirtualFile file, Deployable server, @NotNull Project project, FileObject remoteFile, DeploymentPathMapping mapping) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$TooLargeFile", "<init>"));
            }
            super(file, project);
            this.myServer = server;
            this.myRemoteFile = remoteFile;
            this.myMapping = mapping;
        }

        @Override
        public EditorNotificationPanel createPanel(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotificationPanelCreator$TooLargeFile", "createPanel"));
            }
            EditorNotificationPanel panel = new EditorNotificationPanel();
            panel.setText(WDBundle.message("remote.file.is.too.large.recent.revision.might.not.be.saved", new Object[0]));
            panel.createActionLabel(WDBundle.message("compare.with.remote.file", new Object[0]), () -> {
                AutoUploadComponent.saveDocumentsSilently(this.myProject, Collections.singleton(this.myFile));
                new CompareLocalVsRemoteTask(this.myProject, WDBundle.message("compare.with.server.version", new Object[0]), this.myServer, ToolWindowId.PROJECT_VIEW, LocalMappingDiffRoot.create(this.myFile, this.myMapping)){

                    @Override
                    protected DiffRoot getFullData(ExecutionContextBase context, LocalMappingDiffRoot root) throws FileSystemException {
                        return DiffRoot.create(root.getLocal(), myRemoteFile, root.getMapping());
                    }
                }.queue();
            }).setToolTipText(WDBundle.message("compare.with.remote.file", new Object[0]));
            return panel;
        }
    }
}

