/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerBaseImpl;
import java.io.ByteArrayInputStream;
import java.security.Key;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WebServersAuthStorage
implements PersistentStateComponent<AuthState> {
    private static final Logger LOG = Logger.getInstance(WebServersAuthStorage.class);
    private static final AuthState EMPTY_STATE = new AuthState();
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PASSPHRASE = "passphrase";
    private final transient PropertiesEncryptionSupport myEncryptionSupport = new PropertiesEncryptionSupport((Key)new SecretKeySpec(new byte[]{77, -93, -111, -34, -17, 87, 23, 91, 98, 77, -128, 42, -32, 26, 75, 46}, "AES"));
    @Nullable
    private AuthState myState;

    WebServersAuthStorage() {
    }

    void initServerAuthIfNeeded(@NotNull List<WebServerConfig> servers) {
        if (servers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servers", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage", "initServerAuthIfNeeded"));
        }
        final Properties properties = this.loadProperties(this.myState);
        if (properties != null && !properties.isEmpty()) {
            WebDeploymentCredentialHelper.syncWithPasswordSafe(servers, new OldStorageCredentialProvider(){

                @Override
                @Nullable
                public String getUser(@NotNull WebServerConfig server) {
                    if (server == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$1", "getUser"));
                    }
                    return properties.getProperty(WebServersAuthStorage.getUsernameKey(server.getId()));
                }

                @Override
                @Nullable
                public String getPassword(@NotNull WebServerConfig server) {
                    if (server == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$1", "getPassword"));
                    }
                    return properties.getProperty(WebServersAuthStorage.getPasswordKey(server.getId()));
                }

                @Override
                @Nullable
                public String getPassphrase(@NotNull WebServerConfig server) {
                    if (server == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$1", "getPassphrase"));
                    }
                    return properties.getProperty(WebServersAuthStorage.getPassphraseKey(server.getId()));
                }
            });
        }
        this.myState = EMPTY_STATE;
    }

    @Nullable
    private Properties loadProperties(AuthState state) {
        if (state == null) {
            return null;
        }
        String text = state.getValue();
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        Properties properties = new Properties();
        byte[] encodedBytes = Base64.getDecoder().decode(text);
        try {
            byte[] decrypted = this.myEncryptionSupport.decrypt(encodedBytes);
            properties.load(new ByteArrayInputStream(decrypted));
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        return properties;
    }

    @NotNull
    private static String getUsernameKey(String id) {
        String string = "username." + id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage", "getUsernameKey"));
        }
        return string;
    }

    @NotNull
    private static String getPasswordKey(String id) {
        String string = "password." + id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage", "getPasswordKey"));
        }
        return string;
    }

    @NotNull
    private static String getPassphraseKey(String id) {
        String string = "passphrase." + id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage", "getPassphraseKey"));
        }
        return string;
    }

    @Nullable
    public AuthState getState() {
        return this.myState;
    }

    public void loadState(AuthState state) {
        this.myState = state;
    }

    abstract WebServersConfigManagerBaseImpl<? extends WebServersConfigManagerBaseImpl.State> getService();

    @State(name="webServersAuthStorage", storages={@Storage(value="webServers.xml", roamingType=RoamingType.DISABLED)})
    public static class AppInstance
    extends WebServersAuthStorage {
        public static WebServersAuthStorage getInstance() {
            return (WebServersAuthStorage)ServiceManager.getService(AppInstance.class);
        }

        @Override
        WebServersConfigManagerBaseImpl<? extends WebServersConfigManagerBaseImpl.State> getService() {
            return (WebServersConfigManagerBaseImpl)ServiceManager.getService(WebServersConfigManagerBaseImpl.App.class);
        }
    }

    @State(name="webServersAuthStorage", storages={@Storage(value="$WORKSPACE_FILE$", roamingType=RoamingType.DISABLED)})
    public static class ProjectInstance
    extends WebServersAuthStorage {
        @NotNull
        private final Project myProject;

        public static WebServersAuthStorage getInstance(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$ProjectInstance", "getInstance"));
            }
            return (WebServersAuthStorage)ServiceManager.getService((Project)project, ProjectInstance.class);
        }

        public ProjectInstance(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/WebServersAuthStorage$ProjectInstance", "<init>"));
            }
            this.myProject = project;
        }

        @Override
        WebServersConfigManagerBaseImpl<? extends WebServersConfigManagerBaseImpl.State> getService() {
            return (WebServersConfigManagerBaseImpl)ServiceManager.getService((Project)this.myProject, WebServersConfigManagerBaseImpl.Project.class);
        }
    }

    public static class AuthState {
        String value;

        @Tag(value="data")
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

