/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.util.text.StringKt;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.OldStorageCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0003\u001a.\u0010\f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a\u001c\u0010\u0010\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"copyServerCredentials", "", "from", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "to", "createAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "server", "isPasswordMemoryOnly", "", "getRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "saveCredentials", "userName", "", "password", "syncWithPasswordSafe", "servers", "", "provider", "Lcom/jetbrains/plugins/webDeployment/config/OldStorageCredentialProvider;", "webDeployment"})
@JvmName(name="WebDeploymentCredentialHelper")
public final class WebDeploymentCredentialHelper {
    @JvmOverloads
    public static final void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        PasswordSafe.getInstance().set(WebDeploymentCredentialHelper.createAttributes(server, isPasswordMemoryOnly), new Credentials(StringKt.nullize((String)userName, (boolean)true), password));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void saveCredentials$default(WebServerConfig webServerConfig, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveCredentials");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        WebDeploymentCredentialHelper.saveCredentials(webServerConfig, string, string2, bl);
    }

    @JvmOverloads
    public static void saveCredentials(@NotNull WebServerConfig server, @Nullable String userName, @Nullable String password) {
        WebDeploymentCredentialHelper.saveCredentials$default(server, userName, password, false, 8, null);
    }

    public static final void syncWithPasswordSafe(@NotNull List<? extends WebServerConfig> servers, @NotNull OldStorageCredentialProvider provider) {
        Intrinsics.checkParameterIsNotNull(servers, (String)"servers");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        for (WebServerConfig webServerConfig : servers) {
            String password = StringKt.nullize$default((String)(webServerConfig.getFileTransferConfig().isUseKeyPair() ? provider.getPassphrase(webServerConfig) : provider.getPassword(webServerConfig)), (boolean)false, (int)1, null);
            String userName = StringKt.nullize$default((String)provider.getUser(webServerConfig), (boolean)false, (int)1, null);
            if (userName == null && password == null) continue;
            CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(webServerConfig, false);
            Credentials credentials = passwordSafe.get(attributes);
            if (credentials != null) {
                CharSequence charSequence = (CharSequence)credentials.getPassword();
                if (!(charSequence == null || charSequence.length() == 0) || password == null) continue;
            }
            passwordSafe.set(attributes, new Credentials(userName, password));
        }
    }

    @JvmOverloads
    @NotNull
    public static final CredentialAttributes createAttributes(@NotNull WebServerConfig server, boolean isPasswordMemoryOnly) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        return new CredentialAttributes(CredentialAttributesKt.SERVICE_NAME_PREFIX + " Deployment \u2014 " + server.getId(), null, null, isPasswordMemoryOnly, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ CredentialAttributes createAttributes$default(WebServerConfig webServerConfig, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createAttributes");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return WebDeploymentCredentialHelper.createAttributes(webServerConfig, bl);
    }

    @JvmOverloads
    @NotNull
    public static CredentialAttributes createAttributes(@NotNull WebServerConfig server) {
        return WebDeploymentCredentialHelper.createAttributes$default(server, false, 2, null);
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentials(@NotNull WebServerConfig server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        RemoteCredentialsHolder remoteCredentials = new RemoteCredentialsHolder();
        Deployable deployable = Deployable.create(server);
        deployable.copyToCredentials((MutableRemoteCredentials)remoteCredentials);
        return (RemoteCredentials)remoteCredentials;
    }

    public static final void copyServerCredentials(@NotNull WebServerConfig from, @NotNull WebServerConfig to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes$default(from, false, 2, null);
        Credentials credentials = passwordSafe.get(attributes);
        if (!(credentials == null || StringUtil.isEmptyOrSpaces((String)credentials.getUserName()) && StringUtil.isEmptyOrSpaces((String)credentials.getPasswordAsString()))) {
            boolean isMemoryOnly = passwordSafe.isPasswordStoredOnlyInMemory(attributes, credentials);
            CredentialAttributes cloneAttributes = WebDeploymentCredentialHelper.createAttributes$default(to, false, 2, null);
            passwordSafe.set(cloneAttributes, credentials, isMemoryOnly);
        }
    }
}

