/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.ServerBaseDeployable;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerPasswordSafeDeployable
extends ServerBaseDeployable {
    private static final Logger LOG = Logger.getInstance(ServerBaseDeployable.class);

    public ServerPasswordSafeDeployable(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/config/ServerPasswordSafeDeployable", "<init>"));
        }
        super(server);
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return PasswordSafe.getInstance().get(WebDeploymentCredentialHelper.createAttributes(this.myServer, false));
    }

    @Override
    public void setCredentials(Credentials credentials, boolean memoryOnly, boolean isApplyCredentialsToPasswordSafe, boolean notifyGlobalUpdate) {
        LOG.assertTrue(isApplyCredentialsToPasswordSafe);
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(this.myServer, memoryOnly);
        PasswordSafe.getInstance().set(attributes, credentials);
        if (notifyGlobalUpdate) {
            ApplicationManager.getApplication().invokeLater(() -> ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged());
        }
    }

    @Override
    public boolean isPassMemoryOnly() {
        CredentialAttributes attributes = WebDeploymentCredentialHelper.createAttributes(this.myServer, false);
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        Credentials credentials = passwordSafe.get(attributes);
        if (credentials == null) {
            return true;
        }
        return passwordSafe.isPasswordStoredOnlyInMemory(attributes, credentials);
    }

    @Override
    public String toString() {
        return "ServerPasswordSafeDeployable{myServer=" + this.myServer + '}';
    }
}

